/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.util.Geometry;

public interface MultiblockMachineController {
    public List<Vec3i> getCorePositions();

    public Direction getFacingForMultiblock();

    public BlockPos getPosForMultiblock();

    public Level getWorldForMultiblock();

    public ArrayList<BlockPos> getConnectedCores();

    public void setCoreQuality(float var1);

    public float getCoreQuality();

    public ItemApi.InventoryStorage getInventoryForMultiblock();

    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction var1);

    default public void addMultiblockToNbt(CompoundTag nbt) {
        ListTag posList = new ListTag();
        for (BlockPos pos : this.getConnectedCores()) {
            CompoundTag posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            posList.add((Object)posTag);
        }
        nbt.put("connectedCores", (Tag)posList);
        nbt.putFloat("coreQuality", this.getCoreQuality());
    }

    default public void loadMultiblockNbtData(CompoundTag nbt) {
        ListTag posList = nbt.getList("connectedCores", 10);
        ArrayList<BlockPos> coreBlocksConnected = this.getConnectedCores();
        for (Tag posTag : posList) {
            CompoundTag posCompound = (CompoundTag)posTag;
            int x = posCompound.getInt("x");
            int y = posCompound.getInt("y");
            int z = posCompound.getInt("z");
            BlockPos pos = new BlockPos(x, y, z);
            coreBlocksConnected.add(pos);
        }
        this.setCoreQuality(nbt.getFloat("coreQuality"));
    }

    default public Boolean tryPlaceNextCore(Player player) {
        BlockPos nextPosition;
        ItemStack heldStack = player.getItemBySlot(EquipmentSlot.MAINHAND);
        Item heldItem = heldStack.getItem();
        if (!(heldItem instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)heldItem;
        if (blockItem.getBlock() instanceof MachineCoreBlock && (nextPosition = this.getNextMissingCore()) != null) {
            this.getWorldForMultiblock().setBlockAndUpdate(nextPosition, blockItem.getBlock().defaultBlockState());
            if (!player.isCreative()) {
                heldStack.shrink(1);
                if (heldStack.getCount() == 0) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                }
            }
            return true;
        }
        return false;
    }

    default public BlockPos getNextMissingCore() {
        Level world = this.getWorldForMultiblock();
        BlockPos pos = this.getPosForMultiblock();
        Direction ownFacing = this.getFacingForMultiblock();
        List<Vec3i> targetMachinePositions = this.getCorePositions();
        for (Vec3i targetMachinePosition : targetMachinePositions) {
            Vec3i rotatedPos = Geometry.rotatePosition(targetMachinePosition, ownFacing);
            BlockPos checkPos = pos.offset(rotatedPos);
            BlockState checkState = Objects.requireNonNull(world).getBlockState(checkPos);
            if (!checkState.is(Blocks.AIR) && !checkState.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"replaceable")))) continue;
            return checkPos;
        }
        return null;
    }

    default public boolean initMultiblock(BlockState state) {
        if (((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            return true;
        }
        Level world = this.getWorldForMultiblock();
        BlockPos pos = this.getPosForMultiblock();
        ArrayList<BlockPos> coreBlocksConnected = this.getConnectedCores();
        Direction ownFacing = this.getFacingForMultiblock();
        List<Vec3i> targetMachinePositions = this.getCorePositions();
        ArrayList<MultiBlockElement> coreBlocks = new ArrayList<MultiBlockElement>(targetMachinePositions.size());
        float sumCoreQuality = 0.0f;
        for (Vec3i targetMachinePosition : targetMachinePositions) {
            Vec3i rotatedPos = Geometry.rotatePosition(targetMachinePosition, ownFacing);
            BlockPos checkPos = pos.offset(rotatedPos);
            BlockState checkState = Objects.requireNonNull(world).getBlockState(checkPos);
            Block blockType = checkState.getBlock();
            if (blockType instanceof MachineCoreBlock) {
                MachineCoreBlock coreBlock = (MachineCoreBlock)blockType;
                if (!((Boolean)checkState.getValue((Property)MachineCoreBlock.USED)).booleanValue()) {
                    coreBlocks.add(new MultiBlockElement(checkState, coreBlock, checkPos));
                    sumCoreQuality += coreBlock.getCoreQuality();
                    continue;
                }
            }
            this.highlightBlock(checkPos, world);
        }
        if (targetMachinePositions.size() == coreBlocks.size()) {
            for (MultiBlockElement core : coreBlocks) {
                BlockState newState = (BlockState)core.state.setValue((Property)MachineCoreBlock.USED, (Comparable)Boolean.valueOf(true));
                MachineCoreEntity coreEntity = (MachineCoreEntity)world.getBlockEntity(core.pos());
                coreEntity.setControllerPos(pos);
                world.setBlockAndUpdate(core.pos, newState);
                coreBlocksConnected.add(core.pos);
            }
            float quality = sumCoreQuality / (float)coreBlocks.size();
            this.setCoreQuality(quality);
            Objects.requireNonNull(world).setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    default public void onCoreBroken(BlockPos corePos) {
        Level world = this.getWorldForMultiblock();
        BlockPos pos = this.getPosForMultiblock();
        ArrayList<BlockPos> coreBlocksConnected = this.getConnectedCores();
        Objects.requireNonNull(world).setBlockAndUpdate(pos, (BlockState)world.getBlockState(pos).setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
        for (BlockPos core : coreBlocksConnected) {
            BlockState state;
            if (core.equals((Object)corePos) || !((state = world.getBlockState(core)).getBlock() instanceof MachineCoreBlock)) continue;
            world.setBlockAndUpdate(core, (BlockState)state.setValue((Property)MachineCoreBlock.USED, (Comparable)Boolean.valueOf(false)));
        }
        coreBlocksConnected.clear();
    }

    default public void onControllerBroken() {
        Level world = this.getWorldForMultiblock();
        ArrayList<BlockPos> coreBlocksConnected = this.getConnectedCores();
        for (BlockPos core : coreBlocksConnected) {
            BlockState state = Objects.requireNonNull(world).getBlockState(core);
            if (!(state.getBlock() instanceof MachineCoreBlock)) continue;
            world.setBlockAndUpdate(core, (BlockState)state.setValue((Property)MachineCoreBlock.USED, (Comparable)Boolean.valueOf(false)));
        }
        coreBlocksConnected.clear();
    }

    private void highlightBlock(BlockPos block, Level world) {
        ParticleContent.HIGHLIGHT_BLOCK.spawn(world, Vec3.atLowerCornerOf((Vec3i)block), null);
    }

    public void triggerSetupAnimation();

    public record MultiBlockElement(BlockState state, MachineCoreBlock coreBlock, BlockPos pos) {
    }
}

