/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.blocks.augmenter.AugmentResearchStationBlock;
import rearth.oritech.block.entity.augmenter.PlayerAugments;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.client.ui.PlayerModifierScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SizedIngredient;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AugmentApplicationEntity
extends NetworkedBlockEntity
implements MultiblockMachineController,
GeoBlockEntity,
ExtendedMenuProvider,
ItemApi.BlockProvider,
EnergyApi.BlockProvider,
ScreenProvider {
    public static long maxEnergyTransfer = Oritech.CONFIG.augmenterMaxEnergy() / 10L;
    public static long maxEnergyStored = Oritech.CONFIG.augmenterMaxEnergy();
    private final ArrayList<BlockPos> coreBlocksConnected = new ArrayList();
    private float coreQuality = 1.0f;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final Set<ResourceLocation> researchedAugments = new HashSet<ResourceLocation>();
    @SyncField(value={SyncType.GUI_TICK, SyncType.GUI_OPEN})
    public final HashMap<Integer, ResearchState> availableStations = new HashMap();
    public boolean screenInvOverride = false;
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(5, this::setChanged);
    @SyncField(value={SyncType.GUI_OPEN, SyncType.GUI_TICK})
    private final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(maxEnergyTransfer, maxEnergyStored, maxEnergyStored, this::setChanged);

    public AugmentApplicationEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.PLAYER_MODIFIER_BLOCK_ENTITY, pos, state);
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        this.screenInvOverride = false;
        for (int i = 0; i < 3; ++i) {
            boolean isDone;
            ResearchState station = this.availableStations.getOrDefault(i, null);
            if (station == null || !station.working) continue;
            boolean bl = isDone = world.getGameTime() > station.researchStartedAt + (long)station.workTime;
            if (!isDone) continue;
            this.researchedAugments.add(station.selectedResearch);
            station.working = false;
            this.setChanged();
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory.heldStacks, (boolean)false, (HolderLookup.Provider)registryLookup);
        nbt.putLong("rf", this.energyStorage.getAmount());
        this.addMultiblockToNbt(nbt);
        ListTag list = new ListTag();
        for (ResourceLocation augment : this.researchedAugments) {
            list.add((Object)StringTag.valueOf((String)augment.getPath()));
        }
        for (ResearchState station : this.availableStations.values()) {
            if (station == null || !station.working) continue;
            list.add((Object)StringTag.valueOf((String)station.selectedResearch.getPath()));
        }
        nbt.put("researched", (Tag)list);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory.heldStacks, (HolderLookup.Provider)registryLookup);
        this.energyStorage.setAmount(nbt.getLong("rf"));
        this.loadMultiblockNbtData(nbt);
        ListTag parsedList = nbt.getList("researched", 8);
        for (Tag element : parsedList) {
            ResourceLocation id = Oritech.id(element.getAsString());
            this.researchedAugments.add(id);
        }
    }

    public void researchAugment(ResourceLocation augment, boolean creative, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        if (this.researchedAugments.contains(augment)) {
            Oritech.LOGGER.warn("Player tried to research already researched augment " + String.valueOf(augment));
            return;
        }
        AugmentDataRecipe recipe = (AugmentDataRecipe)((RecipeHolder)this.level.getRecipeManager().byKey(augment).get()).value();
        long extracted = this.energyStorage.extract(recipe.getRfCost(), false);
        block0: for (SizedIngredient wantedInput : recipe.getResearchCost()) {
            int takeAmount;
            Ingredient type = wantedInput.ingredient();
            int missingCount = wantedInput.count();
            for (ItemStack stack : this.inventory.heldStacks) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                break;
            }
            for (ItemStack stack : player.getInventory().items) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                continue block0;
            }
        }
        for (int i = 0; i < 3; ++i) {
            ResearchState station = this.availableStations.getOrDefault(i, null);
            if (station == null || station.working || !BuiltInRegistries.BLOCK.getKey((Object)station.type).equals((Object)recipe.getRequiredStation())) continue;
            station.selectedResearch = augment;
            station.working = true;
            station.researchStartedAt = this.level.getGameTime();
            station.workTime = creative ? 5 : recipe.getTime();
            break;
        }
        this.setChanged();
    }

    public void installAugmentToPlayer(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        if (!this.researchedAugments.contains(augment)) {
            Oritech.LOGGER.warn("Player tried to install augment with id" + String.valueOf(augment) + " without researching it.");
            return;
        }
        AugmentDataRecipe recipe = (AugmentDataRecipe)((RecipeHolder)this.level.getRecipeManager().byKey(augment).get()).value();
        block0: for (SizedIngredient wantedInput : recipe.getApplyCost()) {
            int takeAmount;
            Ingredient type = wantedInput.ingredient();
            int missingCount = wantedInput.count();
            for (ItemStack stack : this.inventory.heldStacks) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                break;
            }
            for (ItemStack stack : player.getInventory().items) {
                if (!type.test(stack)) continue;
                takeAmount = Math.min(stack.getCount(), missingCount);
                stack.shrink(takeAmount);
                if ((missingCount -= takeAmount) > 0) continue;
                continue block0;
            }
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        augmentInstance.installToPlayer(player);
        this.setChanged();
        player.level().playSound(null, player.blockPosition(), SoundContent.SHORT_SERVO, SoundSource.BLOCKS);
    }

    public void removeAugmentFromPlayer(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        augmentInstance.removeFromPlayer(player);
        this.setChanged();
    }

    public static void toggleAugmentForPlayer(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return;
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        if (!augmentInstance.isInstalled(player)) {
            Oritech.LOGGER.error("Tried toggling not-installed augment id: " + String.valueOf(augment) + ". This should never happen");
            return;
        }
        augmentInstance.toggle(player);
    }

    public boolean hasPlayerAugment(ResourceLocation augment, Player player) {
        if (!PlayerAugments.allAugments.containsKey(augment)) {
            Oritech.LOGGER.error("Player augment with id" + String.valueOf(augment) + " not found. This should never happen");
            return false;
        }
        Augment augmentInstance = PlayerAugments.allAugments.get(augment);
        return augmentInstance.isInstalled(player);
    }

    public void loadResearchesFromPlayer(Player player) {
        for (ResourceLocation augmentId : PlayerAugments.allAugments.keySet()) {
            Augment augment = PlayerAugments.allAugments.get(augmentId);
            boolean isInstalled = augment.isInstalled(player);
            boolean isResearched = this.researchedAugments.contains(augmentId);
            if (!isInstalled || isResearched) continue;
            this.researchedAugments.add(augmentId);
        }
    }

    public void loadAvailableStations(Player player) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        List<BlockPos> targetPositions = List.of(new BlockPos(0, 0, -2), new BlockPos(1, 0, 2), new BlockPos(2, 0, -1));
        for (int i = 0; i < targetPositions.size(); ++i) {
            BlockPos candidatePosOffset = targetPositions.get(i);
            BlockPos candidatePos = new BlockPos(Geometry.offsetToWorldPosition(facing, (Vec3i)candidatePosOffset, (Vec3i)this.worldPosition));
            BlockState candidateState = this.level.getBlockState(candidatePos);
            if (!(candidateState.getBlock() instanceof AugmentResearchStationBlock) || !((Boolean)candidateState.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue() || this.availableStations.containsKey(i) && this.availableStations.get(i) != null && this.availableStations.get((Object)Integer.valueOf((int)i)).type.equals(candidateState.getBlock())) continue;
            ResearchState newState = new ResearchState(candidateState.getBlock(), false, ResourceLocation.parse((String)""), -1, -1L);
            this.availableStations.put(i, newState);
        }
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(-1, 0, -1), new Vec3i(0, 1, 1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(-1, 1, -1));
    }

    @Override
    public Direction getFacingForMultiblock() {
        BlockState state = this.getBlockState();
        return ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
    }

    @Override
    public BlockPos getPosForMultiblock() {
        return this.worldPosition;
    }

    @Override
    public Level getWorldForMultiblock() {
        return this.level;
    }

    @Override
    public ArrayList<BlockPos> getConnectedCores() {
        return this.coreBlocksConnected;
    }

    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }

    @Override
    public float getCoreQuality() {
        return this.coreQuality;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return this.inventory;
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public void triggerSetupAnimation() {
        this.triggerAnim("machine", "setup");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "machine", 0, state -> {
            if (state.isCurrentAnimation(MachineBlockEntity.SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    return state.setAndContinue(MachineBlockEntity.IDLE);
                }
                return state.setAndContinue(MachineBlockEntity.SETUP);
            }
            if (((Boolean)this.getBlockState().getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
                return state.setAndContinue(MachineBlockEntity.IDLE);
            }
            return state.setAndContinue(MachineBlockEntity.PACKAGED);
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler()).triggerableAnim("setup", MachineBlockEntity.SETUP));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        this.sendUpdate(SyncType.GUI_OPEN);
        double dist = player.distanceToSqr(this.worldPosition.getBottomCenter());
        if (dist > 1.0 || this.screenInvOverride) {
            return new BasicMachineScreenHandler(syncId, playerInventory, this);
        }
        return new PlayerModifierScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    @Override
    public ItemApi.InventoryStorage getInventoryStorage(Direction direction) {
        return this.inventory;
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 30, 30), new ScreenProvider.GuiSlot(1, 50, 30), new ScreenProvider.GuiSlot(2, 70, 30), new ScreenProvider.GuiSlot(3, 90, 30), new ScreenProvider.GuiSlot(4, 110, 30));
    }

    @Override
    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean showProgress() {
        return false;
    }

    @Override
    public boolean showExpansionPanel() {
        return false;
    }

    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    @Override
    public Container getDisplayedInventory() {
        return this.inventory;
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.AUGMENTER_INV_SCREEN;
    }

    public static class ResearchState {
        public Block type;
        public boolean working;
        public ResourceLocation selectedResearch;
        public int workTime;
        public long researchStartedAt;
        public static StreamCodec<RegistryFriendlyByteBuf, ResearchState> PACKET_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)), ResearchState::getType, (StreamCodec)ByteBufCodecs.BOOL, ResearchState::getWorking, (StreamCodec)ResourceLocation.STREAM_CODEC, ResearchState::getSelectedResearch, (StreamCodec)ByteBufCodecs.INT, ResearchState::getWorkTime, (StreamCodec)ByteBufCodecs.VAR_LONG, ResearchState::getResearchStartedAt, ResearchState::new);

        public Block getType() {
            return this.type;
        }

        public int getWorkTime() {
            return this.workTime;
        }

        public ResourceLocation getSelectedResearch() {
            return this.selectedResearch;
        }

        public long getResearchStartedAt() {
            return this.researchStartedAt;
        }

        public boolean getWorking() {
            return this.working;
        }

        public ResearchState(Block type, boolean working, ResourceLocation selectedResearch, int workTime, long researchStartedAt) {
            this.type = type;
            this.working = working;
            this.selectedResearch = selectedResearch;
            this.workTime = workTime;
            this.researchStartedAt = researchStartedAt;
        }

        public String toString() {
            return "ResearchState{type=" + String.valueOf(this.type) + ", working=" + this.working + ", selectedResearch=" + String.valueOf(this.selectedResearch) + ", workTime=" + this.workTime + ", researchStartedAt=" + this.researchStartedAt + "}";
        }
    }
}

