/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.energy.containers;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;

public class DelegatingEnergyStorage
extends EnergyApi.EnergyStorage {
    protected final Supplier<EnergyApi.EnergyStorage> backingStorage;
    protected final BooleanSupplier validPredicate;

    public DelegatingEnergyStorage(Supplier<EnergyApi.EnergyStorage> backingStorage, @Nullable BooleanSupplier validPredicate) {
        this.backingStorage = backingStorage;
        this.validPredicate = validPredicate == null ? () -> true : validPredicate;
    }

    public DelegatingEnergyStorage(EnergyApi.EnergyStorage backingStorage, @Nullable BooleanSupplier validPredicate) {
        this(() -> backingStorage, validPredicate);
    }

    private boolean canUseBackend() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get() != null;
    }

    @Override
    public long getCapacity() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().getCapacity();
        }
        return 0L;
    }

    @Override
    public void update() {
        if (this.canUseBackend()) {
            this.backingStorage.get().update();
        }
    }

    @Override
    public long insert(long amount, boolean simulate) {
        if (this.canUseBackend()) {
            return this.backingStorage.get().insert(amount, simulate);
        }
        return 0L;
    }

    @Override
    public long extract(long amount, boolean simulate) {
        if (this.canUseBackend()) {
            return this.backingStorage.get().extract(amount, simulate);
        }
        return 0L;
    }

    @Override
    public boolean supportsInsertion() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().supportsInsertion();
        }
        return false;
    }

    @Override
    public boolean supportsExtraction() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().supportsExtraction();
        }
        return false;
    }

    @Override
    public void setAmount(long amount) {
        if (this.canUseBackend()) {
            this.backingStorage.get().setAmount(amount);
        }
    }

    @Override
    public long getAmount() {
        if (this.canUseBackend()) {
            return this.backingStorage.get().getAmount();
        }
        return 0L;
    }
}

