/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.datagen;

import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.paladins.block.PaladinBlocks;
import net.paladins.item.PaladinWeapons;
import net.paladins.item.Shields;
import net.paladins.item.armor.Armors;
import net.spell_engine.api.item.armor.Armor;

public class PaladinRecipes
extends FabricRecipeProvider {
    public PaladinRecipes(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
        super(output, registriesFuture);
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.generateWandRecipes(exporter);
        this.generateStaffRecipes(exporter);
        this.generateClaymoreRecipes(exporter);
        this.generateGreatHammerRecipes(exporter);
        this.generateMaceRecipes(exporter);
        this.generateShieldRecipes(exporter);
        this.generateArmorRecipes(exporter);
        this.generateOtherRecipes(exporter);
        this.generateNetheriteUpgrades(exporter);
    }

    private void generateWandRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.acolyte_wand.item()).pattern(" HH").pattern(" SH").pattern("H  ").define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.STRING), PaladinRecipes.has((ItemLike)Items.STRING)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.holy_wand.item()).pattern(" A").pattern("H ").define(Character.valueOf('A'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('H'), (ItemLike)Items.IRON_INGOT).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GOLD_INGOT), PaladinRecipes.has((ItemLike)Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.diamond_holy_wand.item()).pattern(" A").pattern("H ").define(Character.valueOf('A'), (ItemLike)Items.DIAMOND).define(Character.valueOf('H'), (ItemLike)Items.GOLD_INGOT).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.DIAMOND), PaladinRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateStaffRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.holy_staff.item()).pattern(" AA").pattern(" HA").pattern("H  ").define(Character.valueOf('A'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('H'), (ItemLike)Items.IRON_INGOT).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GOLD_INGOT), PaladinRecipes.has((ItemLike)Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.diamond_holy_staff.item()).pattern(" AA").pattern(" HA").pattern("H  ").define(Character.valueOf('A'), (ItemLike)Items.DIAMOND).define(Character.valueOf('H'), (ItemLike)Items.GOLD_INGOT).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.DIAMOND), PaladinRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateClaymoreRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.stone_claymore.item()).pattern("  A").pattern("AA ").pattern("HA ").define(Character.valueOf('A'), ItemTags.STONE_TOOL_MATERIALS).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.COBBLESTONE), PaladinRecipes.has((ItemLike)Items.COBBLESTONE)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.iron_claymore.item()).pattern("  B").pattern("BB ").pattern("HB ").define(Character.valueOf('B'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.IRON_INGOT), PaladinRecipes.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.golden_claymore.item()).pattern("  B").pattern("BB ").pattern("HB ").define(Character.valueOf('B'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GOLD_INGOT), PaladinRecipes.has((ItemLike)Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.diamond_claymore.item()).pattern("  B").pattern("BB ").pattern("HB ").define(Character.valueOf('B'), (ItemLike)Items.DIAMOND).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.DIAMOND), PaladinRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateGreatHammerRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.wooden_great_hammer.item()).pattern(" BB").pattern(" BB").pattern("H  ").define(Character.valueOf('B'), ItemTags.LOGS_THAT_BURN).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.OAK_LOG), PaladinRecipes.has((ItemLike)Items.OAK_LOG)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.stone_great_hammer.item()).pattern(" BB").pattern(" BB").pattern("H  ").define(Character.valueOf('B'), ItemTags.STONE_TOOL_MATERIALS).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.COBBLESTONE), PaladinRecipes.has((ItemLike)Items.COBBLESTONE)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.iron_great_hammer.item()).pattern(" BB").pattern(" BB").pattern("H  ").define(Character.valueOf('B'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.IRON_INGOT), PaladinRecipes.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.golden_great_hammer.item()).pattern(" BB").pattern(" BB").pattern("H  ").define(Character.valueOf('B'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GOLD_INGOT), PaladinRecipes.has((ItemLike)Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.diamond_great_hammer.item()).pattern(" BB").pattern(" BB").pattern("H  ").define(Character.valueOf('B'), (ItemLike)Items.DIAMOND).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.DIAMOND), PaladinRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateMaceRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.iron_mace.item()).pattern(" B").pattern("HB").define(Character.valueOf('B'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.IRON_INGOT), PaladinRecipes.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.golden_mace.item()).pattern(" B").pattern("HB").define(Character.valueOf('B'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GOLD_INGOT), PaladinRecipes.has((ItemLike)Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)PaladinWeapons.diamond_mace.item()).pattern(" B").pattern("HB").define(Character.valueOf('B'), (ItemLike)Items.DIAMOND).define(Character.valueOf('H'), (ItemLike)Items.STICK).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.DIAMOND), PaladinRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateShieldRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Shields.iron_kite_shield.holder().item).pattern("MLM").pattern("MMM").pattern(" M ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('M'), (ItemLike)Items.IRON_INGOT).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.IRON_INGOT), PaladinRecipes.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Shields.golden_kite_shield.holder().item).pattern("MLM").pattern("MMM").pattern(" M ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('M'), (ItemLike)Items.GOLD_INGOT).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GOLD_INGOT), PaladinRecipes.has((ItemLike)Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Shields.diamond_kite_shield.holder().item).pattern("MLM").pattern("MMM").pattern(" M ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('M'), (ItemLike)Items.DIAMOND).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.DIAMOND), PaladinRecipes.has((ItemLike)Items.DIAMOND)).save(exporter);
    }

    private void generateArmorRecipes(RecipeOutput exporter) {
        this.generatePaladinArmorSet(exporter, Armors.paladinArmorSet_t1, Items.COPPER_INGOT, Items.IRON_INGOT);
        this.generateCrusaderArmorSet(exporter, Armors.paladinArmorSet_t2, Items.GOLD_INGOT, Items.GHAST_TEAR, Items.IRON_INGOT);
        this.generateRobeSet(exporter, Armors.priestArmorSet_t1, Items.CHAIN);
        this.generatePriorRobeSet(exporter, Armors.priestArmorSet_t2, Items.GOLD_INGOT, Items.GHAST_TEAR);
    }

    private void generatePaladinArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item primary, Item secondary) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("ICI").pattern("I I").define(Character.valueOf('C'), (ItemLike)primary).define(Character.valueOf('I'), (ItemLike)secondary).unlockedBy(PaladinRecipes.getHasName((ItemLike)primary), PaladinRecipes.has((ItemLike)primary)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("I I").pattern("ICI").pattern("III").define(Character.valueOf('C'), (ItemLike)primary).define(Character.valueOf('I'), (ItemLike)secondary).unlockedBy(PaladinRecipes.getHasName((ItemLike)primary), PaladinRecipes.has((ItemLike)primary)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("CCC").pattern("I I").pattern("I I").define(Character.valueOf('C'), (ItemLike)primary).define(Character.valueOf('I'), (ItemLike)secondary).unlockedBy(PaladinRecipes.getHasName((ItemLike)primary), PaladinRecipes.has((ItemLike)primary)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("I I").pattern("C C").define(Character.valueOf('C'), (ItemLike)primary).define(Character.valueOf('I'), (ItemLike)secondary).unlockedBy(PaladinRecipes.getHasName((ItemLike)primary), PaladinRecipes.has((ItemLike)primary)).save(exporter);
    }

    private void generateCrusaderArmorSet(RecipeOutput exporter, Armor.Set armorSet, Item gold, Item tear, Item iron) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("GTG").pattern("I I").pattern("III").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('T'), (ItemLike)tear).define(Character.valueOf('I'), (ItemLike)iron).unlockedBy(PaladinRecipes.getHasName((ItemLike)tear), PaladinRecipes.has((ItemLike)tear)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("I I").pattern("GTG").pattern("IGI").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('T'), (ItemLike)tear).define(Character.valueOf('I'), (ItemLike)iron).unlockedBy(PaladinRecipes.getHasName((ItemLike)tear), PaladinRecipes.has((ItemLike)tear)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("GTG").pattern("I I").pattern("G G").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('T'), (ItemLike)tear).define(Character.valueOf('I'), (ItemLike)iron).unlockedBy(PaladinRecipes.getHasName((ItemLike)tear), PaladinRecipes.has((ItemLike)tear)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("I I").pattern("G G").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('I'), (ItemLike)iron).unlockedBy(PaladinRecipes.getHasName((ItemLike)gold), PaladinRecipes.has((ItemLike)gold)).save(exporter);
    }

    private void generateRobeSet(RecipeOutput exporter, Armor.Set armorSet, Item specialIngredient) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("W W").pattern("WLW").define(Character.valueOf('L'), (ItemLike)specialIngredient).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)specialIngredient), PaladinRecipes.has((ItemLike)specialIngredient)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("L L").pattern("WWW").pattern("WWW").define(Character.valueOf('L'), (ItemLike)specialIngredient).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)specialIngredient), PaladinRecipes.has((ItemLike)specialIngredient)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("LLL").pattern("W W").pattern("W W").define(Character.valueOf('L'), (ItemLike)specialIngredient).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)specialIngredient), PaladinRecipes.has((ItemLike)specialIngredient)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("L L").pattern("W W").define(Character.valueOf('L'), (ItemLike)specialIngredient).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)specialIngredient), PaladinRecipes.has((ItemLike)specialIngredient)).save(exporter);
    }

    private void generatePriorRobeSet(RecipeOutput exporter, Armor.Set armorSet, Item gold, Item tear) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.head).pattern("G G").pattern("WTW").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('T'), (ItemLike)tear).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)tear), PaladinRecipes.has((ItemLike)tear)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.chest).pattern("G G").pattern("WTW").pattern("WWW").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('T'), (ItemLike)tear).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)tear), PaladinRecipes.has((ItemLike)tear)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.legs).pattern("GTG").pattern("W W").pattern("W W").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('T'), (ItemLike)tear).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)tear), PaladinRecipes.has((ItemLike)tear)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)armorSet.feet).pattern("G G").pattern("W W").define(Character.valueOf('G'), (ItemLike)gold).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(PaladinRecipes.getHasName((ItemLike)gold), PaladinRecipes.has((ItemLike)gold)).save(exporter);
    }

    private void generateOtherRecipes(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)PaladinBlocks.MONK_WORKBENCH_BLOCK).pattern("GTG").pattern(" # ").pattern("###").define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('T'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('#'), (ItemLike)Items.POLISHED_ANDESITE).unlockedBy(PaladinRecipes.getHasName((ItemLike)Items.GHAST_TEAR), PaladinRecipes.has((ItemLike)Items.GHAST_TEAR)).save(exporter);
    }

    private void generateNetheriteUpgrades(RecipeOutput exporter) {
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)PaladinWeapons.diamond_holy_wand.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)PaladinWeapons.netherite_holy_wand.item());
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)PaladinWeapons.diamond_holy_staff.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)PaladinWeapons.netherite_holy_staff.item());
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)PaladinWeapons.diamond_claymore.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)PaladinWeapons.netherite_claymore.item());
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)PaladinWeapons.diamond_great_hammer.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)PaladinWeapons.netherite_great_hammer.item());
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)PaladinWeapons.diamond_mace.item(), (RecipeCategory)RecipeCategory.COMBAT, (Item)PaladinWeapons.netherite_mace.item());
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Shields.diamond_kite_shield.holder().item, (RecipeCategory)RecipeCategory.COMBAT, (Item)Shields.netherite_kite_shield.holder().item);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.paladinArmorSet_t2.head, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.paladinArmorSet_t3.head);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.paladinArmorSet_t2.chest, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.paladinArmorSet_t3.chest);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.paladinArmorSet_t2.legs, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.paladinArmorSet_t3.legs);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.paladinArmorSet_t2.feet, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.paladinArmorSet_t3.feet);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.priestArmorSet_t2.head, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.priestArmorSet_t3.head);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.priestArmorSet_t2.chest, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.priestArmorSet_t3.chest);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.priestArmorSet_t2.legs, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.priestArmorSet_t3.legs);
        PaladinRecipes.netheriteSmithing((RecipeOutput)exporter, (Item)Armors.priestArmorSet_t2.feet, (RecipeCategory)RecipeCategory.COMBAT, (Item)Armors.priestArmorSet_t3.feet);
    }

    public String getName() {
        return "Paladin Crafting Recipes";
    }
}

