/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.paladins.entity.BarrierEntity;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.compatibility.ShaderCompatibility;
import net.spell_engine.client.util.Color;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BarrierEntityRenderer<T extends BarrierEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation blankTextureId = ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"item/barrier");
    public static final List<BarrierEntity> activeBarriers = new ArrayList<BarrierEntity>();
    private static final int[] LIGHT_UP_ORDER = new int[]{0, 2, 8, 6, 4, 3, 9, 1, 5, 10, 7, 11};

    public static void setup() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            MultiBufferSource.BufferSource vcProvider = Minecraft.getInstance().renderBuffers().bufferSource();
            BarrierEntityRenderer.renderAllInWorld(context.matrixStack(), vcProvider, context.camera(), 0xF000F0, context.tickCounter().getGameTimeDeltaPartialTick(true));
        });
    }

    public BarrierEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTexture(T entity) {
        return null;
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.isAlive()) {
            activeBarriers.add((BarrierEntity)((Object)entity));
        }
        super.render(entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public static void renderAllInWorld(PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, Camera camera, int light, float tickDelta) {
        matrices.pushPose();
        Vec3 camPos = camera.getPosition();
        matrices.translate(-camPos.x, -camPos.y, -camPos.z);
        Config config = ShaderCompatibility.isShaderPackInUse() ? Config.IRIS : Config.VANILLA;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(config.layer());
        for (BarrierEntity entity : activeBarriers) {
            matrices.pushPose();
            matrices.translate(entity.getX(), entity.getY() + 1.0, entity.getZ());
            BarrierEntityRenderer.renderShield(entity, matrices, vertexConsumer, light, tickDelta, config);
            matrices.popPose();
        }
        vertexConsumers.endBatch();
        matrices.popPose();
        activeBarriers.clear();
    }

    public static void renderShield(BarrierEntity entity, PoseStack matrices, VertexConsumer vertexConsumer, int light, float tickDelta, Config config) {
        long time;
        Holder<Spell> entry = entity.getSpellEntry();
        if (entity == null) {
            return;
        }
        Spell spell = (Spell)entry.value();
        float radius = spell.range * 0.8f;
        float zSlant = 0.3926991f;
        float size = radius * Mth.sqrt((float)3.0f) / 3.0f;
        float offset = radius * (Mth.sin((float)zSlant) + 1.0f);
        int overlayUV = OverlayTexture.NO_OVERLAY;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(blankTextureId);
        float u1 = sprite.getU0();
        float u2 = sprite.getU1();
        float v1 = sprite.getV0();
        float v2 = sprite.getV1();
        double fullTime = (double)entity.level().getGameTime() / 20.0;
        double delta = (fullTime - (double)(time = entity.level().getGameTime() / 20L)) * 2.0;
        if (delta > 1.0) {
            delta = 2.0 - delta;
        }
        delta = 1.0 - Math.pow(1.0 - delta, 4.0);
        for (int m = 0; m < 2; ++m) {
            for (int i = 0; i < 6; ++i) {
                matrices.pushPose();
                if (m == 0) {
                    matrices.mulPose(Axis.XP.rotation((float)Math.PI));
                }
                matrices.translate(offset, 0.0f, 0.0f);
                matrices.rotateAround(Axis.YP.rotation((float)((double)((float)i / 3.0f) * Math.PI)), -offset, 0.0f, 0.0f);
                matrices.mulPose(Axis.ZP.rotation(zSlant));
                float r = config.red();
                float g = config.green();
                float b = config.blue();
                float alpha = config.alpha();
                if (entity.tickCount >= entity.getTimeToLive() - entity.expirationDuration()) {
                    int relAge = entity.getTimeToLive() - entity.expirationDuration() - entity.tickCount;
                    alpha = config.expirationPulseAlpha * Math.abs(Mth.cos((float)((float)((double)((float)relAge * 1.25f / 10.0f) * Math.PI))));
                } else if (time % 12L == (long)LIGHT_UP_ORDER[i + m * 6]) {
                    float glow = (float)(0.5 * delta);
                    r = BarrierEntityRenderer.blend(r, 1.0f, glow);
                    g = BarrierEntityRenderer.blend(g, 1.0f, glow);
                    b = BarrierEntityRenderer.blend(b, 1.0f, glow);
                    alpha = BarrierEntityRenderer.blend(alpha, config.panelFlashAlpha(), glow);
                }
                Matrix4f matrix = new Matrix4f((Matrix4fc)matrices.last().pose());
                PoseStack.Pose matrixEntry = matrices.last();
                vertexConsumer.addVertex(matrix, 0.0f, radius, -size).setColor(r, g, b, 0.0f).setUv(u1, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, 0.0f, -size).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, 0.0f, size).setColor(r, g, b, alpha).setUv(u2, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, radius, size).setColor(r, g, b, 0.0f).setUv(u2, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, radius, size).setColor(r, g, b, 0.0f).setUv(u1, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, 0.0f, size).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, 0.0f, -size).setColor(r, g, b, alpha).setUv(u2, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, radius, -size).setColor(r, g, b, 0.0f).setUv(u2, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                matrices.popPose();
                matrices.pushPose();
                Matrix4f newMatrix = matrices.last().pose();
                if (m == 0) {
                    matrices.mulPose(Axis.XP.rotation((float)Math.PI));
                }
                matrices.translate(offset, 0.0f, 0.0f);
                matrices.rotateAround(Axis.YP.rotation((float)((double)((float)(i - 1) / 3.0f) * Math.PI)), -offset, 0.0f, 0.0f);
                matrices.mulPose(Axis.ZP.rotation(zSlant));
                vertexConsumer.addVertex(matrix, 0.0f, radius, size).setColor(r, g, b, 0.0f).setUv(u2, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, 0.0f, size).setColor(r, g, b, alpha).setUv(u2, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(newMatrix, 0.0f, 0.0f, -size).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, radius, size).setColor(r, g, b, 0.0f).setUv(u1, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, radius, size).setColor(r, g, b, 0.0f).setUv(u2, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(newMatrix, 0.0f, 0.0f, -size).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, 0.0f, size).setColor(r, g, b, alpha).setUv(u2, v1).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrix, 0.0f, radius, size).setColor(r, g, b, 0.0f).setUv(u1, v2).setOverlay(overlayUV).setLight(light).setNormal(matrixEntry, 0.0f, 0.0f, 0.0f);
                matrices.popPose();
            }
        }
    }

    public static float blend(float min, float max, float delta) {
        return min + (max - min) * delta;
    }

    private record Config(RenderType layer, float red, float green, float blue, float alpha, float panelFlashAlpha, float expirationPulseAlpha) {
        private static final Color shield = Color.from((int)0xFFCC66);
        public static final Config VANILLA = new Config(CustomLayers.create((ResourceLocation)TextureAtlas.LOCATION_BLOCKS, (RenderStateShard.ShaderStateShard)RenderStateShard.RENDERTYPE_BEACON_BEAM_SHADER, (RenderStateShard.TransparencyStateShard)RenderStateShard.TRANSLUCENT_TRANSPARENCY, (RenderStateShard.CullStateShard)RenderStateShard.NO_CULL, (RenderStateShard.WriteMaskStateShard)RenderStateShard.COLOR_WRITE, (RenderStateShard.OverlayStateShard)RenderStateShard.OVERLAY, (RenderStateShard.OutputStateShard)RenderStateShard.MAIN_TARGET, (boolean)true), shield.red(), shield.green(), shield.blue(), 0.8f, 0.9f, 1.0f);
        public static final Config IRIS = new Config(CustomLayers.create((ResourceLocation)TextureAtlas.LOCATION_BLOCKS, (RenderStateShard.ShaderStateShard)RenderStateShard.RENDERTYPE_LIGHTNING_SHADER, (RenderStateShard.TransparencyStateShard)RenderStateShard.LIGHTNING_TRANSPARENCY, (RenderStateShard.CullStateShard)RenderStateShard.NO_CULL, (RenderStateShard.WriteMaskStateShard)RenderStateShard.COLOR_WRITE, (RenderStateShard.OverlayStateShard)RenderStateShard.OVERLAY, (RenderStateShard.OutputStateShard)RenderStateShard.MAIN_TARGET, (boolean)false), shield.red(), shield.green(), shield.blue(), 0.5f, 1.0f, 0.8f);
    }
}

