/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SpellBookCreationCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_book_creation");
    public static final SpellBookCreationCriteria INSTANCE = new SpellBookCreationCriteria();

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public void trigger(ServerPlayer player, ResourceLocation spellPoolId) {
        this.trigger(player, condition -> condition.matches(spellPoolId));
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<String> spell_pool) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)Codec.optionalField((String)"spell_pool", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::spell_pool)).apply((Applicative)instance, Condition::new));

        public boolean matches(ResourceLocation id) {
            boolean poolMatches = true;
            if (this.spell_pool.isPresent()) {
                poolMatches = this.spell_pool.get().equals(id.toString());
            }
            return poolMatches;
        }
    }
}

