/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.SpellBooks;
import net.spell_engine.api.item.trinket.ISpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.api.tags.SpellEngineItemTags;

public class SpellBinding {
    public static final ResourceLocation ADVANCEMENT_VISIT_ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"visit_spell_binding_table");
    public static final String name = "spell_binding";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_binding");
    private static final float LIBRARY_POWER_BASE = 10.0f;
    private static final float LIBRARY_POWER_MULTIPLIER = 1.5f;
    private static final int LIBRARY_POWER_CAP = 18;
    public static final int BOOK_OFFSET = 1;

    public static List<ISpellBookItem> availableSpellBooks(Level world) {
        return SpellBooks.sorted(world).stream().filter(spellBookItem -> {
            Item item = spellBookItem.asItem();
            Holder entry = BuiltInRegistries.ITEM.wrapAsHolder((Object)item);
            return !entry.is(SpellEngineItemTags.NON_CRAFTABLE_SPELL_BOOK);
        }).toList();
    }

    public static OfferResult offersFor(Level world, boolean creative, ItemStack itemStack, ItemStack consumableStack, int libraryPower) {
        List<Holder<Spell>> spells;
        if (itemStack.getItem() == Items.BOOK) {
            List<ISpellBookItem> books = SpellBinding.availableSpellBooks(world);
            ArrayList<Offer> offers = new ArrayList<Offer>();
            if (SpellEngineMod.config.spell_book_creation_enabled) {
                for (int i = 0; i < books.size(); ++i) {
                    offers.add(new Offer(i + 1, SpellEngineMod.config.spell_book_creation_cost, SpellEngineMod.config.spell_book_creation_requirement, 0, true));
                }
            }
            return new OfferResult(Mode.BOOK, offers);
        }
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null) {
            return new OfferResult(Mode.SPELL, List.of());
        }
        List<Holder<Spell>> pool = SpellRegistry.entries(world, container.pool());
        if (pool == null || pool.isEmpty()) {
            return new OfferResult(Mode.SPELL, List.of());
        }
        SpellContainer consumableContainer = SpellContainerHelper.containerFromItemStack(consumableStack);
        boolean scrollMode = false;
        if (consumableStack.is(SpellEngineItemTags.SPELL_BOOK_MERGEABLE) && consumableContainer != null) {
            scrollMode = true;
            Registry<Spell> spellRegistry = SpellRegistry.from(world);
            List<Holder.Reference> consumableSpells = consumableContainer.spell_ids().stream().map(ResourceLocation::parse).map(arg_0 -> spellRegistry.getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get).toList();
            Set availableSpellIds = pool.stream().map(entry -> ((ResourceKey)entry.unwrapKey().get()).location()).collect(Collectors.toSet());
            spells = consumableSpells.stream().filter(entry -> {
                ResourceLocation spellId = ((ResourceKey)entry.unwrapKey().get()).location();
                return availableSpellIds.contains(spellId) || creative;
            }).map(entry -> entry).toList();
        } else {
            spells = pool;
        }
        HashMap spellMap = new HashMap();
        spells.forEach(entry -> {
            Spell spell = (Spell)entry.value();
            spellMap.put(((ResourceKey)entry.unwrapKey().get()).location(), spell);
        });
        boolean finalScrollMode = scrollMode;
        return new OfferResult(Mode.SPELL, spellMap.entrySet().stream().sorted(SpellContainerHelper.spellSorter).map(entry -> {
            Spell spell = (Spell)entry.getValue();
            if (finalScrollMode) {
                int cost = spell.tier * SpellEngineMod.config.spell_scroll_level_cost_per_tier + SpellEngineMod.config.spell_scroll_apply_cost_base;
                int levelRequirement = 1;
                return new Offer(SpellBinding.rawSpellId(world, (ResourceLocation)entry.getKey()), cost, levelRequirement, 0, true);
            }
            if (spell.learn != null && spell.tier > 0) {
                int cost = spell.tier * spell.learn.level_cost_per_tier;
                int levelRequirement = spell.tier * spell.learn.level_requirement_per_tier;
                return new Offer(SpellBinding.rawSpellId(world, (ResourceLocation)entry.getKey()), cost * SpellEngineMod.config.spell_binding_level_cost_multiplier, levelRequirement, cost * SpellEngineMod.config.spell_binding_lapis_cost_multiplier, libraryPower == 18 || 10.0f + (float)libraryPower * 1.5f >= (float)levelRequirement);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static int rawSpellId(Level world, ResourceLocation spellId) {
        Registry<Spell> registry = SpellRegistry.from(world);
        Holder.Reference entry = (Holder.Reference)registry.getHolder(spellId).get();
        return registry.getId((Object)((Spell)entry.value()));
    }

    public record Offer(int id, int levelCost, int levelRequirement, int lapisCost, boolean isPowered) {
    }

    public record OfferResult(Mode mode, List<Offer> offers) {
    }

    public static enum Mode {
        SPELL,
        BOOK;

    }

    public static class State {
        public ApplyState state;
        public Requirements requirements;

        public State(ApplyState state, Requirements requirements) {
            this.state = state;
            this.requirements = requirements;
        }

        public static State of(Level world, int spellId, ItemStack itemStack, int levelCost, int requiredLevel, int lapisCost) {
            Registry<Spell> registry = SpellRegistry.from(world);
            Optional spellEntry = registry.getHolder(spellId);
            if (spellEntry.isEmpty()) {
                return new State(ApplyState.INVALID, null);
            }
            return State.of(((ResourceKey)((Holder.Reference)spellEntry.get()).unwrapKey().get()).location(), itemStack, levelCost, requiredLevel, lapisCost);
        }

        public static State of(ResourceLocation spellId, ItemStack itemStack, int requiredLevel, int levelCost, int lapisCost) {
            SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
            Requirements requirements = new Requirements(lapisCost, levelCost, requiredLevel);
            if (container == null) {
                return new State(ApplyState.INVALID, requirements);
            }
            if (container.spell_ids().contains(spellId.toString())) {
                return new State(ApplyState.ALREADY_APPLIED, requirements);
            }
            if (container.max_spell_count() > 0 && container.spell_ids().size() >= container.max_spell_count()) {
                return new State(ApplyState.NO_MORE_SLOT, requirements);
            }
            return new State(ApplyState.APPLICABLE, requirements);
        }

        public boolean readyToApply(Player player, int lapisCount) {
            return this.state == ApplyState.APPLICABLE && this.requirements != null && this.requirements.satisfiedFor(player, lapisCount);
        }

        public static State forBook(int cost, int requiredLevel) {
            Requirements requirements = new Requirements(0, cost, requiredLevel);
            return new State(ApplyState.APPLICABLE, requirements);
        }

        public static enum ApplyState {
            ALREADY_APPLIED,
            NO_MORE_SLOT,
            APPLICABLE,
            INVALID;

        }

        public record Requirements(int lapisCost, int levelCost, int requiredLevel) {
            public boolean satisfiedFor(Player player, int lapisCount) {
                return player.isCreative() || this.metRequiredLevel(player) && this.hasEnoughLapis(lapisCount) && this.hasEnoughLevelsToSpend(player);
            }

            public boolean metRequiredLevel(Player player) {
                return player.experienceLevel >= this.requiredLevel;
            }

            public boolean hasEnoughLapis(int lapisCount) {
                return lapisCount >= this.lapisCost;
            }

            public boolean hasEnoughLevelsToSpend(Player player) {
                return player.experienceLevel >= this.levelCost;
            }
        }
    }
}

