/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.item.ScrollItem;
import net.spell_engine.item.SpellEngineItems;
import org.jetbrains.annotations.Nullable;

public class SpellBindRandomlyLootFunction
extends LootItemConditionalFunction {
    public static final String NAME = "spell_bind_randomly";
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"spell_bind_randomly");
    public static final MapCodec<SpellBindRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SpellBindRandomlyLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.STRING.fieldOf("pool").orElse(null).forGetter(function -> function.pool), (App)NumberProviders.CODEC.fieldOf("tier").forGetter(function -> function.tier), (App)NumberProviders.CODEC.fieldOf("count").forGetter(function -> function.count))).apply((Applicative)instance, SpellBindRandomlyLootFunction::new));
    public static final LootItemFunctionType<SpellBindRandomlyLootFunction> TYPE = new LootItemFunctionType(CODEC);
    private final NumberProvider tier;
    @Nullable
    private final String pool;
    @Nullable
    private final NumberProvider count;

    private SpellBindRandomlyLootFunction(List<LootItemCondition> conditions, String pool, NumberProvider tier, NumberProvider count) {
        super(conditions);
        this.pool = pool;
        this.tier = tier;
        this.count = count;
    }

    public LootItemFunctionType<SpellBindRandomlyLootFunction> getType() {
        return TYPE;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of();
    }

    @Nullable
    TagKey<Spell> getSpellTag() {
        if (this.pool == null || this.pool.isEmpty()) {
            return null;
        }
        ResourceLocation id = this.pool.startsWith("#") ? ResourceLocation.parse((String)this.pool.substring(1)) : ResourceLocation.parse((String)this.pool);
        return TagKey.create(SpellRegistry.KEY, (ResourceLocation)id);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        SpellContainer.ContentType selectedContentType;
        TagKey<Spell> spellTag = this.getSpellTag();
        int selectedTier = this.tier != null ? this.tier.getInt(context) : -1;
        SpellContainer existingContainer = SpellContainerHelper.containerFromItemStack(stack);
        List alreadyPresentSpells = existingContainer != null ? existingContainer.spell_ids().stream().map(ResourceLocation::parse).toList() : List.of();
        List<Holder.Reference> spells = SpellRegistry.stream((Level)context.getLevel()).filter(entry -> {
            ResourceLocation id = ((ResourceKey)entry.unwrapKey().get()).location();
            return !(selectedTier >= 0 && ((Spell)entry.value()).tier != selectedTier || spellTag != null && !entry.is(spellTag) || alreadyPresentSpells.contains(id));
        }).toList();
        ArrayList<Holder.Reference> selectedSpells = new ArrayList<Holder.Reference>();
        SpellContainer.ContentType contentType = selectedContentType = existingContainer != null ? existingContainer.content() : null;
        if (!spells.isEmpty()) {
            int selectedCount = this.count != null ? this.count.getInt(context) : 1;
            int retryAttempts = 3;
            for (int i = 0; i < selectedCount; ++i) {
                Holder.Reference entry2 = spells.get(context.getRandom().nextInt(spells.size()));
                while (retryAttempts > 0 && (selectedSpells.contains(entry2) || selectedContentType != null && Objects.equals((Object)SpellContainerHelper.contentTypeForSpell((Spell)entry2.value()), (Object)selectedContentType))) {
                    entry2 = spells.get(context.getRandom().nextInt(spells.size()));
                    --retryAttempts;
                }
                selectedSpells.add(entry2);
                selectedContentType = SpellContainerHelper.contentTypeForSpell((Spell)entry2.value());
            }
        }
        if (!selectedSpells.isEmpty()) {
            SpellContainer newContainer = existingContainer != null ? existingContainer : SpellContainer.EMPTY.withContentType(selectedContentType != null ? selectedContentType : SpellContainer.ContentType.MAGIC);
            List<String> newSpellIds = selectedSpells.stream().map(entry -> ((ResourceKey)entry.unwrapKey().get()).location().toString()).toList();
            newContainer = newContainer.withAdditionalSpell(newSpellIds);
            List<String> sortedSpellIds = SpellContainerHelper.sortedSpells((Level)context.getLevel(), newContainer.spell_ids());
            newContainer = newContainer.copyWith(sortedSpellIds);
            stack.set(SpellDataComponents.SPELL_CONTAINER, (Object)newContainer);
            if (stack.getItem() == SpellEngineItems.SCROLL.get()) {
                ScrollItem.onSpellAdded(stack, (Holder<Spell>)((Holder)selectedSpells.getFirst()), ScrollItem.resolveSpellPool((Level)context.getLevel(), (Holder<Spell>)((Holder)selectedSpells.getFirst())));
            }
        } else if (stack.getItem() == SpellEngineItems.SCROLL.get()) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(String pool, NumberProvider tier, NumberProvider count) {
        return SpellBindRandomlyLootFunction.simpleBuilder(conditions -> new SpellBindRandomlyLootFunction((List<LootItemCondition>)conditions, pool, tier, count));
    }
}

