/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.entity;

import java.util.List;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.spell_engine.api.item.set.EquipmentSet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Player.class})
public class PlayerEquipmentSetMixin
implements EquipmentSet.Owner {
    @Unique
    private List<EquipmentSet.Result> activeEquipmentSets = List.of();

    @Override
    public List<EquipmentSet.Result> getActiveEquipmentSets() {
        return this.activeEquipmentSets;
    }

    @Override
    public void setActiveEquipmentSets(List<EquipmentSet.Result> results) {
        AttributeInstance entityAttributeInstance;
        Player player = (Player)this;
        AttributeMap attributeContainer = player.getAttributes();
        for (ItemAttributeModifiers bonus : EquipmentSet.attributesFrom(this.activeEquipmentSets)) {
            for (ItemAttributeModifiers.Entry modifier : bonus.modifiers()) {
                entityAttributeInstance = attributeContainer.getInstance(modifier.attribute());
                if (entityAttributeInstance == null) continue;
                entityAttributeInstance.removeModifier(modifier.modifier());
            }
        }
        this.activeEquipmentSets = results;
        for (ItemAttributeModifiers bonus : EquipmentSet.attributesFrom(this.activeEquipmentSets)) {
            for (ItemAttributeModifiers.Entry modifier : bonus.modifiers()) {
                entityAttributeInstance = attributeContainer.getInstance(modifier.attribute());
                if (entityAttributeInstance == null) continue;
                entityAttributeInstance.removeModifier(modifier.modifier().id());
                entityAttributeInstance.addTransientModifier(modifier.modifier());
            }
        }
    }
}

