/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class EnchantmentSpecificCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"enchant_specific");
    public static final EnchantmentSpecificCriteria INSTANCE = new EnchantmentSpecificCriteria();

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public void trigger(ServerPlayer player, ResourceLocation spellPoolId) {
        this.trigger(player, condition -> condition.matches(spellPoolId));
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<String> enchant_id) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)Codec.optionalField((String)"enchant_id", (Codec)Codec.STRING, (boolean)true).forGetter(Condition::enchant_id)).apply((Applicative)instance, Condition::new));

        public boolean matches(ResourceLocation id) {
            boolean poolMatches = true;
            if (this.enchant_id.isPresent()) {
                poolMatches = this.enchant_id.get().equals(id.toString());
            }
            return poolMatches;
        }
    }
}

