/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellCooldownManager {
    private final Map<ResourceLocation, Entry> entries = Maps.newHashMap();
    private int tick;
    private final Player owner;
    private static final String NBT_KEY = "spell_engine_cooldowns";

    public SpellCooldownManager(Player owner) {
        this.owner = owner;
    }

    public boolean isCoolingDown(ResourceLocation spell) {
        return this.getCooldownProgress(spell, 0.0f) > 0.0f;
    }

    public float getCooldownProgress(ResourceLocation spell, float tickDelta) {
        Entry entry = this.entries.get(spell);
        if (entry != null) {
            float f = entry.endTick - entry.startTick;
            float g = (float)entry.endTick - ((float)this.tick + tickDelta);
            return Mth.clamp((float)(g / f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public int getCooldownDuration(ResourceLocation spell) {
        Entry entry = this.entries.get(spell);
        if (entry != null) {
            return entry.timeLeft(this.tick);
        }
        return 0;
    }

    public void setDurationLeft(ResourceLocation spell, int duration) {
        Entry existingEntry = this.entries.get(spell);
        if (existingEntry != null) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
        } else if (duration > 0) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
        }
    }

    public void tickUpdate() {
        ++this.tick;
        this.update(true);
    }

    public void update(boolean sync) {
        if (!this.entries.isEmpty()) {
            Iterator<Map.Entry<ResourceLocation, Entry>> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Entry> entry = iterator.next();
                if (entry.getValue().endTick > this.tick) continue;
                iterator.remove();
                if (!sync) continue;
                this.cooldownCleared(entry.getKey());
            }
        }
    }

    public void set(ResourceLocation spell, int duration, boolean force) {
        if (force || !this.entries.containsKey(spell) || this.entries.get(spell).timeLeft(this.tick) < duration) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
            this.cooldownSet(spell, duration);
        }
    }

    public void set(ResourceLocation spell, int duration) {
        this.set(spell, duration, true);
    }

    public void remove(ResourceLocation spell) {
        this.entries.remove(spell);
        this.cooldownCleared(spell);
    }

    protected void cooldownSet(ResourceLocation spell, int duration) {
        Player player = this.owner;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)new Packets.SpellCooldown(spell, duration));
        }
    }

    protected void cooldownCleared(ResourceLocation spell) {
        Player player = this.owner;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)new Packets.SpellCooldown(spell, 0));
        }
    }

    public void writeCustomDataToNbt(CompoundTag nbt) {
        CompoundTag cooldowns = new CompoundTag();
        for (Map.Entry<ResourceLocation, Entry> entry : this.entries.entrySet()) {
            ResourceLocation spell = entry.getKey();
            Entry cooldown = entry.getValue();
            CompoundTag cooldownData = new CompoundTag();
            cooldownData.putInt("start", cooldown.startTick - this.tick);
            cooldownData.putInt("end", cooldown.endTick - this.tick);
            cooldowns.put(spell.toString(), (Tag)cooldownData);
        }
        nbt.put(NBT_KEY, (Tag)cooldowns);
    }

    public void readCustomDataFromNbt(CompoundTag nbt) {
        CompoundTag cooldowns = nbt.getCompound(NBT_KEY);
        for (String key : cooldowns.getAllKeys()) {
            ResourceLocation spell = ResourceLocation.parse((String)key);
            CompoundTag cooldownData = cooldowns.getCompound(key);
            int start = cooldownData.getInt("start");
            int end = cooldownData.getInt("end");
            this.entries.put(spell, new Entry(start, end));
        }
    }

    public void reset(@Nullable ResourceLocation spellId) {
        if (spellId == null) {
            this.entries.clear();
        } else {
            this.entries.remove(spellId);
        }
        this.pushSync();
    }

    public void pushSync() {
        Player player = this.owner;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)new Packets.SpellCooldownSync(this.tick, Map.copyOf(this.entries)));
        }
    }

    public void acceptSync(int baseTick, Map<ResourceLocation, Entry> cooldowns) {
        this.tick = baseTick;
        this.entries.clear();
        this.entries.putAll(cooldowns);
    }

    public List<ResourceLocation> spellsOnCooldown() {
        return this.entries.keySet().stream().toList();
    }

    public record Entry(int startTick, int endTick) {
        int timeLeft(int currentTick) {
            return Math.max(0, this.endTick - currentTick);
        }
    }
}

