/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.particle.TemplateParticleEffect;
import net.spell_engine.client.util.Color;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.TargetHelper;
import net.spell_engine.utils.VectorHelper;
import org.jetbrains.annotations.Nullable;

public class ParticleHelper {
    private static Random rng = new Random();

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches) {
        ParticleHelper.sendBatches(trackedEntity, batches, true);
    }

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches, boolean includeSourceEntity) {
        ParticleHelper.sendBatches(trackedEntity, batches, 1.0f, PlayerLookup.tracking((Entity)trackedEntity), includeSourceEntity);
    }

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<ServerPlayer> trackers) {
        ParticleHelper.sendBatches(trackedEntity, batches, countMultiplier, trackers, true);
    }

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<ServerPlayer> trackers, boolean includeSourceEntity) {
        ServerPlayer serverPlayer2;
        if (batches == null || batches.length == 0) {
            return;
        }
        int sourceEntityId = trackedEntity.getId();
        Packets.ParticleBatches.SourceType sourceType = Packets.ParticleBatches.SourceType.COORDINATE;
        ArrayList<Packets.ParticleBatches.Spawn> spawns = new ArrayList<Packets.ParticleBatches.Spawn>();
        for (ParticleBatch batch : batches) {
            Vec3 sourceLocation = Vec3.ZERO;
            switch (sourceType) {
                case ENTITY: {
                    break;
                }
                case COORDINATE: {
                    sourceLocation = ParticleHelper.origin(trackedEntity, batch.origin);
                }
            }
            spawns.add(new Packets.ParticleBatches.Spawn(includeSourceEntity ? sourceEntityId : 0, trackedEntity.getYRot(), trackedEntity.getXRot(), sourceLocation, batch));
        }
        Packets.ParticleBatches packet = new Packets.ParticleBatches(sourceType, countMultiplier, spawns);
        if (trackedEntity instanceof ServerPlayer && ServerPlayNetworking.canSend((ServerPlayer)(serverPlayer2 = (ServerPlayer)trackedEntity), (ResourceLocation)Packets.ParticleBatches.ID)) {
            ServerPlayNetworking.send((ServerPlayer)serverPlayer2, (CustomPacketPayload)packet);
        }
        trackers.forEach(serverPlayer -> {
            if (ServerPlayNetworking.canSend((ServerPlayer)serverPlayer, (ResourceLocation)Packets.ParticleBatches.ID)) {
                ServerPlayNetworking.send((ServerPlayer)serverPlayer, (CustomPacketPayload)packet);
            }
        });
    }

    public static void play(Level world, Entity source, ParticleBatch[] batches) {
        if (batches == null) {
            return;
        }
        for (ParticleBatch batch : batches) {
            ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
        }
    }

    public static void play(Level world, Entity source, ParticleBatch batch) {
        ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
    }

    public static void play(Level world, Entity entity, float yaw, float pitch, ParticleBatch batch) {
        ParticleHelper.play(world, entity.tickCount, ParticleHelper.origin(entity, batch.origin), entity.getBbWidth(), yaw, pitch, batch, entity);
    }

    private static ParticleOptions resolveParticleType(ParticleBatch batch, @Nullable Entity sourceEntity) {
        ResourceLocation id = ResourceLocation.parse((String)batch.particle_id);
        ParticleOptions particle = (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(id);
        if (particle instanceof TemplateParticleEffect) {
            TemplateParticleEffect templateParticleEffect = (TemplateParticleEffect)particle;
            TemplateParticleEffect copy = templateParticleEffect.copy();
            TemplateParticleEffect.Appearance appearance = copy.createOrDefaultAppearance();
            if (batch.color_rgba >= 0L) {
                appearance.color = Color.fromRGBA(batch.color_rgba);
            }
            if (batch.follow_entity) {
                appearance.entityFollowed = sourceEntity;
            }
            if (batch.scale != 1.0f) {
                appearance.scale = batch.scale;
            }
            if (batch.origin == ParticleBatch.Origin.GROUND) {
                appearance.grounded = true;
            }
            appearance.max_age = batch.max_age;
            particle = copy;
        }
        return particle;
    }

    public static void play(Level world, long time, Vec3 origin, float width, float yaw, float pitch, ParticleBatch batch, @Nullable Entity sourceEntity) {
        try {
            ParticleOptions particle = ParticleHelper.resolveParticleType(batch, sourceEntity);
            float count = batch.count;
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                Vec3 direction = ParticleHelper.direction(batch, time, yaw, pitch);
                Vec3 particleSpecificOrigin = origin.add(ParticleHelper.offset(width, batch.extent, batch.shape, direction.normalize(), batch.rotation, yaw, pitch));
                if (batch.pre_spawn_travel != 0.0f) {
                    particleSpecificOrigin = particleSpecificOrigin.add(direction.scale((double)batch.pre_spawn_travel));
                }
                if (batch.invert) {
                    direction = direction.reverse();
                }
                world.addParticle(particle, true, particleSpecificOrigin.x, particleSpecificOrigin.y, particleSpecificOrigin.z, direction.x, direction.y, direction.z);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to play particle batch - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static List<SpawnInstruction> convertToInstructions(Level world, Packets.ParticleBatches packet) {
        ArrayList<SpawnInstruction> instructions = new ArrayList<SpawnInstruction>();
        Packets.ParticleBatches.SourceType sourceType = packet.sourceType();
        for (Packets.ParticleBatches.Spawn spawn : packet.spawns()) {
            float yaw = spawn.yaw();
            float pitch = spawn.pitch();
            ParticleBatch batch = spawn.batch();
            Vec3 origin = Vec3.ZERO;
            float width = 0.5f;
            Entity sourceEntity = world.getEntity(spawn.sourceEntityId());
            switch (sourceType) {
                case ENTITY: {
                    origin = ParticleHelper.origin(sourceEntity, batch.origin);
                    break;
                }
                case COORDINATE: {
                    origin = spawn.sourceLocation();
                }
            }
            ParticleOptions particle = ParticleHelper.resolveParticleType(batch, sourceEntity);
            float count = batch.count;
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                Vec3 direction = ParticleHelper.direction(batch, world.getGameTime(), yaw, pitch);
                Vec3 particleSpecificOrigin = origin.add(ParticleHelper.offset(width, batch.extent, batch.shape, direction.normalize(), batch.rotation, yaw, pitch));
                if (batch.pre_spawn_travel != 0.0f) {
                    particleSpecificOrigin = particleSpecificOrigin.add(direction.scale((double)batch.pre_spawn_travel));
                }
                if (batch.invert) {
                    direction = direction.reverse();
                }
                instructions.add(new SpawnInstruction(particle, sourceEntity, particleSpecificOrigin.x, particleSpecificOrigin.y, particleSpecificOrigin.z, direction.x, direction.y, direction.z));
                ++i;
            }
        }
        return instructions;
    }

    private static Vec3 origin(Entity entity, ParticleBatch.Origin origin) {
        switch (origin) {
            case FEET: {
                return entity.position().add(0.0, (double)(entity.getBbHeight() * 0.1f), 0.0);
            }
            case CENTER: {
                return entity.position().add(0.0, (double)(entity.getBbHeight() * 0.5f), 0.0);
            }
            case LAUNCH_POINT: {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    return SpellHelper.launchPoint(livingEntity);
                }
                return entity.position().add(0.0, (double)(entity.getBbHeight() * 0.5f), 0.0);
            }
            case GROUND: {
                Vec3 position = TargetHelper.findSolidBelow(entity, entity.position(), entity.level(), -2.0f);
                if (position != null) {
                    return new Vec3(entity.getX(), position.y() + (double)0.1f, entity.getZ());
                }
                return entity.position().add(0.0, (double)0.1f, 0.0);
            }
        }
        return entity.position();
    }

    private static Vec3 offset(float width, float extent, ParticleBatch.Shape shape, Vec3 direction, ParticleBatch.Rotation rotation, float yaw, float pitch) {
        Vec3 offset = Vec3.ZERO;
        if (extent >= 1000.0f) {
            width = 0.0f;
            extent -= 1000.0f;
        }
        switch (shape) {
            case LINE_VERTICAL: 
            case CIRCLE: 
            case CONE: 
            case SPHERE: {
                if (extent > 0.0f) {
                    offset = direction.scale((double)extent);
                }
                return offset;
            }
            case PIPE: {
                float size = width * 0.5f + extent;
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new Vec3((double)size, 0.0, 0.0).yRot(angle);
                break;
            }
            case WIDE_PIPE: {
                float size = width + extent;
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new Vec3((double)size, 0.0, 0.0).yRot(angle);
                break;
            }
            case PILLAR: {
                float x = (width * 0.5f + extent) * rng.nextFloat();
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new Vec3((double)x, 0.0, 0.0).yRot(angle);
            }
        }
        if (rotation != null) {
            switch (rotation) {
                case LOOK: {
                    offset = offset.xRot((float)Math.toRadians(-1.0f * (pitch + 90.0f))).yRot((float)Math.toRadians(-yaw));
                }
            }
        }
        return offset;
    }

    private static Vec3 direction(ParticleBatch batch, long time, float yaw, float pitch) {
        Vec3 direction = Vec3.ZERO;
        float rotateAroundX = 0.0f;
        float rotateAroundY = 0.0f;
        switch (batch.shape) {
            case LINE: {
                direction = new Vec3(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed));
                pitch = -pitch;
                break;
            }
            case CONE: {
                direction = new Vec3(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                rotateAroundX += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                rotateAroundY += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                break;
            }
            case CIRCLE: {
                direction = new Vec3(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed)).yRot((float)Math.toRadians(rng.nextFloat() * 360.0f));
                break;
            }
            case LINE_VERTICAL: 
            case PIPE: 
            case WIDE_PIPE: 
            case PILLAR: {
                direction = new Vec3(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                break;
            }
            case SPHERE: {
                direction = new Vec3((double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0, 0.0).zRot((float)Math.toRadians(rng.nextFloat() * 360.0f)).yRot((float)Math.toRadians(rng.nextFloat() * 360.0f));
            }
        }
        if (batch.rotation != null) {
            switch (batch.rotation) {
                case LOOK: {
                    float pRot = -pitch;
                    float yRot = yaw * -1.0f;
                    direction = direction.xRot((float)Math.toRadians(pRot - 90.0f + rotateAroundX)).yRot((float)Math.toRadians(yRot + rotateAroundY));
                    if (!(batch.roll > 0.0f)) break;
                    Vec3 axis = VectorHelper.axisFromRotation(yRot, pRot).reverse();
                    float diff = (float)time * batch.roll % 360.0f + batch.roll_offset;
                    direction = VectorHelper.rotateAround(direction, axis, diff);
                }
            }
        } else {
            direction = direction.xRot((float)Math.toRadians(rotateAroundX)).yRot((float)Math.toRadians(rotateAroundY));
            if (batch.roll > 0.0f) {
                float diff = (float)time * batch.roll % 360.0f + batch.roll_offset;
                direction = direction.yRot((float)Math.toRadians(diff));
            }
        }
        return direction;
    }

    private static float randomInRange(float min, float max) {
        float range = max - min;
        return min + range * rng.nextFloat();
    }

    private static float randomSignedInRange(float min, float max) {
        float rand = rng.nextFloat();
        float range = max - min;
        float sign = rand > 0.5f ? 1.0f : -1.0f;
        float base = sign * min;
        float varied = sign * range * rand;
        return base + varied;
    }

    public record SpawnInstruction(ParticleOptions particle, @Nullable Entity sourceEntity, double positionX, double positionY, double positionZ, double velocityX, double velocityY, double velocityZ) {
        public void perform(Level world) {
            try {
                world.addParticle(this.particle, true, this.positionX, this.positionY, this.positionZ, this.velocityX, this.velocityY, this.velocityZ);
            }
            catch (Exception e) {
                System.err.println("Failed to perform particle SpawnInstruction");
            }
        }
    }
}

