/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import org.jetbrains.annotations.Nullable;

public class MultipartEntityCompat {
    public static final ArrayList<Function<Entity, Entity>> resolvers = new ArrayList();

    public static void addResolver(Function<Entity, Entity> resolver) {
        resolvers.add(resolver);
    }

    @Nullable
    public static Entity getOwner(Entity entity) {
        for (Function<Entity, Entity> resolver : resolvers) {
            Entity owner = resolver.apply(entity);
            if (owner == null) continue;
            return owner;
        }
        return null;
    }

    public static Entity coalesce(Entity entity) {
        Entity owner = MultipartEntityCompat.getOwner(entity);
        return owner != null ? owner : entity;
    }

    static {
        resolvers.add(entity -> {
            if (entity instanceof EnderDragonPart) {
                return ((EnderDragonPart)entity).parentMob;
            }
            return null;
        });
    }
}

