/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.spellbinding.SpellBindingBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class SpellBindingBlockEntityRenderer
implements BlockEntityRenderer<SpellBindingBlockEntity> {
    public static final Material BOOK_TEXTURE = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"spell_engine", (String)"entity/spell_binding_book"));
    private final BookModel book;

    public SpellBindingBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.book = new BookModel(ctx.bakeLayer(ModelLayers.BOOK));
    }

    public void render(SpellBindingBlockEntity blockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j) {
        float h;
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.75, 0.5);
        float g = (float)blockEntity.ticks + f;
        matrixStack.translate(0.0f, 0.1f + Mth.sin((float)(g * 0.1f)) * 0.01f, 0.0f);
        for (h = blockEntity.bookRotation - blockEntity.lastBookRotation; h >= (float)Math.PI; h -= (float)Math.PI * 2) {
        }
        while (h < (float)(-Math.PI)) {
            h += (float)Math.PI * 2;
        }
        float k = blockEntity.lastBookRotation + h * f;
        matrixStack.mulPose(Axis.YP.rotation(-k));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(80.0f));
        float l = Mth.lerp((float)f, (float)blockEntity.pageAngle, (float)blockEntity.nextPageAngle);
        float m = Mth.frac((float)(l + 0.25f)) * 1.6f - 0.3f;
        float n = Mth.frac((float)(l + 0.75f)) * 1.6f - 0.3f;
        float o = Mth.lerp((float)f, (float)blockEntity.pageTurningSpeed, (float)blockEntity.nextPageTurningSpeed);
        this.book.setupAnim(g, Mth.clamp((float)m, (float)0.0f, (float)1.0f), Mth.clamp((float)n, (float)0.0f, (float)1.0f), o);
        VertexConsumer vertexConsumer = BOOK_TEXTURE.buffer(vertexConsumerProvider, RenderType::entitySolid);
        this.book.render(matrixStack, vertexConsumer, i, j, -1);
        matrixStack.popPose();
    }
}

