/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell.fx;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.spell.fx.SoundRandom;

public final class Sound {
    private String id = null;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private float randomness = 0.1f;

    public Sound() {
    }

    public Sound(String id) {
        this.id = id;
    }

    public Sound(ResourceLocation id) {
        this(id.toString());
    }

    public Sound(String id, float volume, float pitch, float randomness) {
        this.id = id;
        this.volume = volume;
        this.pitch = pitch;
        this.randomness = randomness;
    }

    public Sound(ResourceLocation id, float randomness) {
        this(id.toString(), 1.0f, 1.0f, randomness);
    }

    public static Sound withRandomness(ResourceLocation id, float randomness) {
        Sound sound = new Sound(id.toString());
        sound.randomness = randomness;
        return sound;
    }

    public static Sound withVolume(ResourceLocation id, float volume) {
        Sound sound = new Sound(id.toString());
        sound.volume = volume;
        return sound;
    }

    public String id() {
        return this.id;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }

    public float randomness() {
        return this.randomness;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Sound that = (Sound)obj;
        return Objects.equals(this.id, that.id) && Float.floatToIntBits(this.volume) == Float.floatToIntBits(that.volume) && Float.floatToIntBits(this.pitch) == Float.floatToIntBits(that.pitch) && Float.floatToIntBits(this.randomness) == Float.floatToIntBits(that.randomness);
    }

    public int hashCode() {
        return Objects.hash(this.id, Float.valueOf(this.volume), Float.valueOf(this.pitch), Float.valueOf(this.randomness));
    }

    public String toString() {
        return "Sound[id=" + this.id + ", volume=" + this.volume + ", pitch=" + this.pitch + ", randomness=" + this.randomness + "]";
    }

    public float randomizedPitch() {
        float pitch = this.randomness() > 0.0f ? SoundRandom.rng.nextFloat(this.pitch() - this.randomness(), this.pitch() + this.randomness()) : this.pitch();
        return pitch;
    }

    public Sound copy() {
        Sound copy = new Sound(this.id);
        copy.volume = this.volume;
        copy.pitch = this.pitch;
        copy.randomness = this.randomness;
        return copy;
    }
}

