/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.internals.SpellTriggers;

public class TickingStatusEffect
extends MobEffect {
    private int interval = 10;

    public TickingStatusEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public TickingStatusEffect interval(int interval) {
        this.interval = interval;
        return this;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Holder entry = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)this);
            if (entry != null) {
                SpellTriggers.onEffectTick(player, (Holder<MobEffect>)entry);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % this.interval == 0;
    }
}

