/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class SimpleParticleGenerator
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SimpleParticleGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generateSimpleParticles(Builder var1);

    public CompletableFuture<?> run(CachedOutput writer) {
        Builder builder = new Builder();
        this.generateSimpleParticles(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            ParticleData data = entry.particle();
            ResourceLocation id = entry.id;
            JsonElement json = gson.toJsonTree((Object)data);
            Path path = this.getFilePath(id);
            writes.add(DataProvider.saveStable((CachedOutput)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Simple Particle Generator";
    }

    private Path getFilePath(ResourceLocation spellId) {
        return this.dataOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "particles").json(spellId);
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();

        public void add(ResourceLocation id, ParticleData spell) {
            this.entries.add(new Entry(id, spell));
        }
    }

    public record Entry(ResourceLocation id, ParticleData particle) {
    }

    public record ParticleData(List<String> textures) {
    }
}

