/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.arsenal.item.Group;
import net.arsenal.item.Loot;
import net.arsenal.spell.ArsenalSpells;
import net.fabric_extras.ranged_weapon.api.CustomBow;
import net.fabric_extras.ranged_weapon.api.CustomCrossbow;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainerHelper;

public class ArsenalBows {
    public static final ArrayList<RangedEntry> entries = new ArrayList();
    private static final int durabilityTier0 = 384;
    private static final int durabilityTier1 = 465;
    private static final int durabilityTier2 = net.minecraft.world.item.Tiers.DIAMOND.getUses();
    private static final int durabilityTier3 = net.minecraft.world.item.Tiers.NETHERITE.getUses();
    private static final int durabilityTier4 = durabilityTier3 * 2;
    private static final float pullTime_shortBow = -0.19999999f;
    private static final float pullTime_longBow = 0.5f;
    private static final float pullTime_rapidCrossbow = 0.0f;
    private static final float pullTime_heavyCrossbow = 0.75f;
    private static final float velocity_shortBow = 0.0f;
    private static final float velocity_longBow = 0.75f;
    private static final float velocity_rapidCrossbow = 0.0f;
    private static final float velocity_heavyCrossbow = 0.5f;
    public static RangedEntry unique_longbow_1 = ArsenalBows.bow("unique_longbow_1", durabilityTier4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK}), new RangedConfig(13.5f, 0.5f, 0.75f)).translatedName("Sunfury Hawk-Bow").spell(ArsenalSpells.radiance_ranged.id()).loot(5, Loot.Theme.DIVINE.toString());
    public static RangedEntry unique_longbow_2 = ArsenalBows.bow("unique_longbow_2", durabilityTier4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), new RangedConfig(13.5f, 0.5f, 0.75f)).translatedName("Black Bow of the Betrayer").spell(ArsenalSpells.wither_ranged.id()).loot(5, Loot.Theme.EVIL.toString());
    public static RangedEntry unique_longbow_sw = ArsenalBows.bow("unique_longbow_sw", durabilityTier4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK}), new RangedConfig(13.5f, 0.5f, 0.75f)).translatedName("Golden Bow of Quel'Thalas").spell(ArsenalSpells.rampaging_ranged.id()).loot(5, Loot.Theme.ELVEN.toString());
    public static RangedEntry unique_heavy_crossbow_1 = ArsenalBows.crossbow("unique_heavy_crossbow_1", durabilityTier4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), new RangedConfig(17.0f, 0.75f, 0.5f)).translatedName("Heavy Crossbow of the Phoenix").spell(ArsenalSpells.flame_cloud_ranged.id()).loot(5, Loot.Theme.FIERY.toString());
    public static RangedEntry unique_heavy_crossbow_2 = ArsenalBows.crossbow("unique_heavy_crossbow_2", durabilityTier4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE_BLOCK}), new RangedConfig(17.0f, 0.75f, 0.5f)).translatedName("Necropolis Ballista").spell(ArsenalSpells.poison_cloud_ranged.id()).loot(5, Loot.Theme.EVIL.toString());
    public static RangedEntry unique_heavy_crossbow_sw = ArsenalBows.crossbow("unique_heavy_crossbow_sw", durabilityTier4, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_BLOCK}), new RangedConfig(17.0f, 0.75f, 0.5f)).translatedName("Crossbow of Relentless Strikes").spell(ArsenalSpells.bonus_shot_ranged.id()).loot(5, Loot.Theme.ELVEN.toString());

    private static RangedEntry bow(String name, int durability, Supplier<Ingredient> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)name), CustomBow::new, defaults, repairIngredientSupplier, durability);
        entry.weaponAttributesPreset = "bow_two_handed_heavy";
        entry.weaponType = Equipment.WeaponType.LONG_BOW;
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    private static RangedEntry crossbow(String name, int durability, Supplier<Ingredient> repairIngredientSupplier, RangedConfig defaults) {
        RangedEntry entry = new RangedEntry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)name), CustomCrossbow::new, defaults, repairIngredientSupplier, durability);
        entry.weaponAttributesPreset = "crossbow_two_handed_heavy";
        entry.weaponType = Equipment.WeaponType.HEAVY_CROSSBOW;
        entry.lootProperties = Equipment.LootProperties.of((int)5);
        entries.add(entry);
        return entry;
    }

    public static void register(Map<String, RangedConfig> rangedConfig) {
        int netheriteTier = Tiers.unsafe((String)"netherite");
        for (RangedEntry entry : entries) {
            RangedConfig config = rangedConfig.get(entry.id.toString());
            if (config == null) {
                config = entry.defaults;
                rangedConfig.put(entry.id.toString(), config);
            }
            Item.Properties settings = new Item.Properties();
            int tier = Tiers.unsafe((ResourceLocation)entry.id());
            if (tier >= netheriteTier) {
                settings.fireResistant();
            }
            if (entry.rarity != Rarity.COMMON) {
                settings.rarity(entry.rarity);
            }
            if (entry.spells != null) {
                if (entry.spells.isEmpty()) {
                    settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForRangedWeapon());
                } else {
                    settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForRangedWeapon(entry.spells));
                }
            }
            Item item = entry.create(settings, config);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id, (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (RangedEntry entry : entries) {
                content.accept((ItemLike)entry.item);
            }
        });
    }

    static {
        for (RangedEntry entry : entries) {
            entry.rarity = Rarity.RARE;
        }
    }

    public static final class RangedEntry {
        private final ResourceLocation id;
        private final RangedFactory factory;
        private final RangedConfig defaults;
        private final Supplier<Ingredient> repairIngredientSupplier;
        private final int durability;
        public String weaponAttributesPreset;
        private String translatedName = "";
        public Rarity rarity = Rarity.COMMON;
        public Item item;
        public List<ResourceLocation> spells = null;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;
        public Equipment.WeaponType weaponType = Equipment.WeaponType.LONG_BOW;

        public RangedEntry(ResourceLocation id, RangedFactory factory, RangedConfig defaults, Supplier<Ingredient> repairIngredientSupplier, int durability) {
            this.id = id;
            this.factory = factory;
            this.defaults = defaults;
            this.repairIngredientSupplier = repairIngredientSupplier;
            this.durability = durability;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public RangedFactory factory() {
            return this.factory;
        }

        public RangedConfig defaults() {
            return this.defaults;
        }

        public Supplier<Ingredient> repairIngredientSupplier() {
            return this.repairIngredientSupplier;
        }

        public int durability() {
            return this.durability;
        }

        public Item create(Item.Properties settings, RangedConfig config) {
            this.item = this.factory.create(settings.durability(this.durability), config, this.repairIngredientSupplier);
            return this.item;
        }

        public Item item() {
            return this.item;
        }

        public RangedEntry translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public String translationKey() {
            return Util.makeDescriptionId((String)"item", (ResourceLocation)this.id());
        }

        public RangedEntry castSpell() {
            this.spells = List.of();
            return this;
        }

        public RangedEntry spell(ResourceLocation spellId) {
            this.spells = List.of(spellId);
            return this;
        }

        public RangedEntry loot(int tier, String theme) {
            this.lootProperties = Equipment.LootProperties.of((int)tier, (String)theme);
            return this;
        }
    }

    public static interface RangedFactory {
        public Item create(Item.Properties var1, RangedConfig var2, Supplier<Ingredient> var3);
    }
}

