/*
 * Decompiled with CFR 0.152.
 */
package net.archers.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.archers.content.ArcherSounds;
import net.archers.item.Group;
import net.archers.item.armor.ArcherArmor;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;

public class ArcherArmors {
    public static Holder<ArmorMaterial> material_t1 = ArcherArmors.material("archer_armor", 2, 3, 3, 2, 9, ArcherSounds.ARCHER_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}));
    public static Holder<ArmorMaterial> material_t2 = ArcherArmors.material("ranger_armor", 2, 3, 3, 2, 10, ArcherSounds.ARCHER_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_HIDE}));
    public static Holder<ArmorMaterial> material_t3 = ArcherArmors.material("netherite_ranger_armor", 2, 3, 3, 2, 15, ArcherSounds.ARCHER_ARMOR_EQUIP.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    public static final float damage_T1 = 0.05f;
    public static final float haste_T2 = 0.03f;
    public static final float damage_T2 = 0.08f;
    public static final float haste_T3 = 0.04f;
    public static final float damage_T3 = 0.09f;
    public static final Armor.Set archerArmorSet_T1 = ArcherArmors.create(material_t1, ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"archer_armor"), 15, ArcherArmor::archer, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArcherArmors.damageMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArcherArmors.damageMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArcherArmors.damageMultiplier(0.05f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArcherArmors.damageMultiplier(0.05f))), 1).armorSet();
    public static final Armor.Set archerArmorSet_T2 = ArcherArmors.create(material_t2, ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"ranger_armor"), 25, ArcherArmor::ranger, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArcherArmors.damageMultiplier(0.08f)).add(ArcherArmors.hasteMultiplier(0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArcherArmors.damageMultiplier(0.08f)).add(ArcherArmors.hasteMultiplier(0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArcherArmors.damageMultiplier(0.08f)).add(ArcherArmors.hasteMultiplier(0.03f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArcherArmors.damageMultiplier(0.08f)).add(ArcherArmors.hasteMultiplier(0.03f))), 2).armorSet();
    public static final Armor.Set archerArmorSet_T3 = ArcherArmors.create(material_t3, ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"netherite_ranger_armor"), 35, ArcherArmor::ranger, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArcherArmors.damageMultiplier(0.09f)).add(ArcherArmors.hasteMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArcherArmors.damageMultiplier(0.09f)).add(ArcherArmors.hasteMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(ArcherArmors.damageMultiplier(0.09f)).add(ArcherArmors.hasteMultiplier(0.04f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(ArcherArmors.damageMultiplier(0.09f)).add(ArcherArmors.hasteMultiplier(0.04f))), 3).armorSet();

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"archers", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"archers", (String)name), (Object)material);
    }

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, int tier) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier));
        entries.add(entry);
        return entry;
    }

    private static AttributeModifier damageMultiplier(float value) {
        return new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier hasteMultiplier(float value) {
        return new AttributeModifier(EntityAttributes_RangedWeapon.HASTE.id.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

