/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.structure_pool.api;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabric_extras.structure_pool.internal.StructurePoolExtension;
import net.fabric_extras.structure_pool.mixin.StructurePoolAccessor;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class StructurePoolAPI {
    private static final ArrayList<StructurePoolConfig.Entry> pendingInjections = new ArrayList();
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"empty"));
    public static HashMap<ResourceLocation, HashMap<ResourceLocation, SpawnPerk>> spawnLimitations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectAll(StructurePoolConfig config) {
        ArrayList<StructurePoolConfig.Entry> arrayList = pendingInjections;
        synchronized (arrayList) {
            pendingInjections.addAll(config.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processInjections(MinecraftServer server) {
        ArrayList<StructurePoolConfig.Entry> arrayList = pendingInjections;
        synchronized (arrayList) {
            for (StructurePoolConfig.Entry entry : pendingInjections) {
                ResourceLocation pooldId = ResourceLocation.parse((String)entry.pool);
                for (StructurePoolConfig.Entry.Structure structure : entry.structures) {
                    ResourceLocation structureId = ResourceLocation.parse((String)structure.id);
                    StructurePoolAPI.injectIntoStructurePool(server, pooldId, structureId, structure.weight);
                    if (structure.limit <= 0) continue;
                    StructurePoolAPI.limitSpawn(pooldId, structureId, structure.limit);
                }
            }
        }
    }

    public static void injectIntoStructurePool(MinecraftServer server, ResourceLocation poolId, ResourceLocation structureId, int weight) {
        Holder.Reference emptyProcessorList = server.registryAccess().registryOrThrow(Registries.PROCESSOR_LIST).getHolderOrThrow(EMPTY_PROCESSOR_LIST_KEY);
        Optional poolGetter = server.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL).getOptional(poolId);
        if (poolGetter.isEmpty()) {
            System.err.println("StructurePool API: cannot add to " + String.valueOf(poolId) + " as it cannot be found!");
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)poolGetter.get();
        ObjectArrayList<StructurePoolElement> pieceList = ((StructurePoolAccessor)pool).getElements();
        SinglePoolElement piece = (SinglePoolElement)StructurePoolElement.single((String)structureId.toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        ((StructurePoolExtension)pool).remember((StructurePoolElement)piece, structureId);
        ArrayList<Pair<StructurePoolElement, Integer>> list = new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)pool).getElementCounts());
        list.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)piece, (Object)weight));
        ((StructurePoolAccessor)pool).setElementCounts(list);
        for (int i = 0; i < weight; ++i) {
            pieceList.add((Object)piece);
        }
    }

    public static void limitSpawn(ResourceLocation poolId, ResourceLocation structureId, int limit) {
        if (!spawnLimitations.containsKey(poolId)) {
            spawnLimitations.put(poolId, new HashMap());
        }
        spawnLimitations.get(poolId).put(structureId, new SpawnPerk(limit));
    }

    public record SpawnPerk(int limit) {
    }
}

