/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.villager;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.runes.api.RuneItems;
import net.runes.crafting.RuneCraftingBlock;
import net.wizards.WizardsMod;
import net.wizards.content.WizardsSounds;
import net.wizards.item.WizardArmors;
import net.wizards.item.WizardWeapons;

public class WizardVillagers {
    public static final String WIZARD_MERCHANT = "wizard_merchant";
    public static final ResourceLocation POI_ID = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"wizard_merchant");

    public static void registerPOI() {
        ImmutableSet blockStates = ImmutableSet.copyOf((Collection)RuneCraftingBlock.INSTANCE.getStateDefinition().getPossibleStates());
        PointOfInterestHelper.register((ResourceLocation)POI_ID, (int)1, (int)10, (Iterable)blockStates);
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)name);
        return (VillagerProfession)Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)name), (Object)new VillagerProfession(id.toString(), entry -> entry.is(workStation), entry -> entry.is(workStation), ImmutableSet.of(), ImmutableSet.of(), WizardsSounds.WIZARD_ROBES_EQUIP.soundEvent()));
    }

    public static void register() {
        if (!FabricLoader.getInstance().isModLoaded("lithostitched")) {
            StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)WizardsMod.villageConfig.value));
        }
        VillagerProfession profession = WizardVillagers.registerProfession(WIZARD_MERCHANT, (ResourceKey<PoiType>)ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)POI_ID));
        LinkedHashMap<Integer, List<Object>> trades = new LinkedHashMap<Integer, List<Object>>();
        trades.put(1, List.of(new VillagerTrades.ItemsForEmeralds(RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.ARCANE), 2, 8, 128, 3, 0.1f), new VillagerTrades.ItemsForEmeralds(RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.FIRE), 2, 8, 128, 3, 0.1f), new VillagerTrades.ItemsForEmeralds(RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.FROST), 2, 8, 128, 3, 0.1f)));
        trades.put(2, List.of(new VillagerTrades.ItemsForEmeralds(WizardWeapons.wizardStaff.item(), 4, 1, 12, 18), new VillagerTrades.ItemsForEmeralds(WizardWeapons.noviceWand.item(), 4, 1, 12, 18), new VillagerTrades.ItemsForEmeralds(WizardWeapons.arcaneWand.item(), 18, 1, 12, 18), new VillagerTrades.ItemsForEmeralds(WizardWeapons.fireWand.item(), 18, 1, 12, 18), new VillagerTrades.ItemsForEmeralds(WizardWeapons.frostWand.item(), 18, 1, 12, 18), new VillagerTrades.EmeraldForItems((ItemLike)Items.WHITE_WOOL, 10, 12, 5, 6), new VillagerTrades.EmeraldForItems((ItemLike)Items.LAPIS_LAZULI, 6, 3, 5, 12)));
        trades.put(3, List.of(new VillagerTrades.ItemsForEmeralds((Item)WizardArmors.wizardRobeSet.head, 15, 1, 12, 16, 0.1f), new VillagerTrades.ItemsForEmeralds((Item)WizardArmors.wizardRobeSet.feet, 15, 1, 12, 16, 0.1f)));
        trades.put(4, List.of(new VillagerTrades.ItemsForEmeralds((Item)WizardArmors.wizardRobeSet.chest, 20, 1, 12, 16, 0.1f), new VillagerTrades.ItemsForEmeralds((Item)WizardArmors.wizardRobeSet.legs, 20, 1, 12, 16, 0.1f)));
        for (Map.Entry entry : trades.entrySet()) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)((Integer)entry.getKey()), factories -> factories.addAll((Collection)entry.getValue()));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(WizardWeapons.arcaneStaff.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(WizardWeapons.fireStaff.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(WizardWeapons.frostStaff.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
        });
    }
}

