/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class WizardsSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry ARCANE_MISSILE_RELEASE = WizardsSounds.add(new Entry("arcane_missile_release"));
    public static final Entry ARCANE_MISSILE_IMPACT = WizardsSounds.add(new Entry("arcane_missile_impact"));
    public static final Entry ARCANE_SHOOT_SMALL = WizardsSounds.add(new Entry("arcane_shoot_small"));
    public static final Entry ARCANE_BLAST_RELEASE = WizardsSounds.add(new Entry("arcane_blast_release"));
    public static final Entry ARCANE_BLAST_IMPACT = WizardsSounds.add(new Entry("arcane_blast_impact"));
    public static final Entry ARCANE_BEAM_START = WizardsSounds.add(new Entry("arcane_beam_start"));
    public static final Entry ARCANE_BEAM_CASTING = WizardsSounds.add(new Entry("arcane_beam_casting"));
    public static final Entry ARCANE_BEAM_IMPACT = WizardsSounds.add(new Entry("arcane_beam_impact"));
    public static final Entry ARCANE_BEAM_RELEASE = WizardsSounds.add(new Entry("arcane_beam_release"));
    public static final Entry FIRE_SCORCH_IMPACT = WizardsSounds.add(new Entry("fire_scorch_impact"));
    public static final Entry FIREBALL_IMPACT = WizardsSounds.add(new Entry("fireball_impact"));
    public static final Entry FIRE_BREATH_START = WizardsSounds.add(new Entry("fire_breath_start"));
    public static final Entry FIRE_BREATH_CASTING = WizardsSounds.add(new Entry("fire_breath_casting"));
    public static final Entry FIRE_BREATH_RELEASE = WizardsSounds.add(new Entry("fire_breath_release"));
    public static final Entry FIRE_BREATH_IMPACT = WizardsSounds.add(new Entry("fire_breath_impact"));
    public static final Entry FIRE_METEOR_RELEASE = WizardsSounds.add(new Entry("fire_meteor_release").travelDistance(48.0f));
    public static final Entry FIRE_METEOR_IMPACT = WizardsSounds.add(new Entry("fire_meteor_impact"));
    public static final Entry FIRE_WALL_IGNITE = WizardsSounds.add(new Entry("fire_wall_ignite"));
    public static final Entry FROST_SHARD_IMPACT = WizardsSounds.add(new Entry("frost_shard_impact"));
    public static final Entry FROST_NOVA_RELEASE = WizardsSounds.add(new Entry("frost_nova_release"));
    public static final Entry FROST_NOVA_DAMAGE_IMPACT = WizardsSounds.add(new Entry("frost_nova_damage_impact"));
    public static final Entry FROST_NOVA_EFFECT_IMPACT = WizardsSounds.add(new Entry("frost_nova_effect_impact"));
    public static final Entry FROST_SHIELD_RELEASE = WizardsSounds.add(new Entry("frost_shield_release"));
    public static final Entry FROST_SHIELD_IMPACT = WizardsSounds.add(new Entry("frost_shield_impact"));
    public static final Entry FROST_BLIZZARD_CASTING = WizardsSounds.add(new Entry("frost_blizzard_casting"));
    public static final Entry WIZARD_ROBES_EQUIP = WizardsSounds.add(new Entry("wizard_robes_equip").variants(3));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }
    }
}

