/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.client.gui.AccessoriesExperimentalScreen;
import io.wispforest.accessories.client.gui.components.AccessoriesContainingComponent;
import io.wispforest.accessories.client.gui.components.CollectedPositionedRectangle;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.ExtendedScrollContainer;
import io.wispforest.accessories.menu.variants.AccessoriesExperimentalMenu;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class ScrollableAccessoriesComponent
extends FlowLayout
implements AccessoriesContainingComponent {
    private final int totalRowCount;
    private final int maxRowCount;
    private final FlowLayout fullAccessoriesLayout;
    private final FlowLayout fullCosmeticsLayout;
    private final List<PositionedRectangle> alternativeButtonChecks;
    private final AccessoriesExperimentalScreen screen;
    private final boolean showScrollbar;

    protected ScrollableAccessoriesComponent(AccessoriesExperimentalScreen screen, Data componentData) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.VERTICAL);
        this.setupID();
        this.screen = screen;
        this.totalRowCount = componentData.totalRowCount();
        this.maxRowCount = componentData.maxRowCount();
        this.fullAccessoriesLayout = componentData.fullAccessoriesLayout();
        this.fullCosmeticsLayout = componentData.fullCosmeticsLayout();
        this.alternativeButtonChecks = componentData.alternativeButtonChecks();
        this.showScrollbar = componentData.showScrollbar();
        Vector2i minimumDimensions = componentData.minimumDimensions();
        this.build(minimumDimensions.x, minimumDimensions.y, componentData.showScrollbar());
    }

    @Nullable
    public static ScrollableAccessoriesComponent createOrNull(AccessoriesExperimentalScreen screen) {
        Data data = ScrollableAccessoriesComponent.buildPages(screen);
        if (data == null) {
            return null;
        }
        return new ScrollableAccessoriesComponent(screen, data);
    }

    @Nullable
    private static Data buildPages(AccessoriesExperimentalScreen screen) {
        AccessoriesExperimentalMenu menu = (AccessoriesExperimentalMenu)screen.getMenu();
        List<Slot> slots = menu.getVisibleAccessoriesSlots();
        int gridSize = 7;
        int maxColumnCount = menu.owner().accessoriesHolder().columnAmount();
        int maxRowCount = gridSize;
        int totalRowCount = (int)Math.ceil((float)slots.size() / 2.0f / (float)maxColumnCount);
        if (totalRowCount <= 0) {
            return null;
        }
        int minimumWidth = maxColumnCount * 18;
        int minimumHeight = maxRowCount * 18;
        FlowLayout fullAccessoriesLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("accessories_container");
        FlowLayout fullCosmeticsLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).id("cosmetics_container");
        ArrayList<PositionedRectangle> alternativeButtonChecks = new ArrayList<PositionedRectangle>();
        for (int row = 0; row < totalRowCount; ++row) {
            int colStartingIndex = row * (maxColumnCount * 2);
            FlowLayout accessoriesRowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).surface(screen.FULL_SLOT_RENDERING).id("row_" + row);
            FlowLayout cosmeticRowLayout = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).surface(screen.FULL_SLOT_RENDERING).id("row_" + row);
            ArrayList<PositionedRectangle> rowButtons = new ArrayList<PositionedRectangle>();
            boolean overMaxSlots = false;
            for (int col = 0; col < maxColumnCount; ++col) {
                int cosmetic = colStartingIndex + col * 2;
                int accessory = cosmetic + 1;
                if (accessory >= slots.size() || cosmetic >= slots.size()) {
                    overMaxSlots = true;
                    break;
                }
                AccessoriesBasedSlot cosmeticSlot = (AccessoriesBasedSlot)slots.get(cosmetic);
                AccessoriesBasedSlot accessorySlot = (AccessoriesBasedSlot)slots.get(accessory);
                screen.hideSlot(cosmeticSlot);
                screen.hideSlot(accessorySlot);
                screen.enableSlot(screen.showCosmeticState() ? cosmeticSlot : accessorySlot);
                screen.disableSlot(screen.showCosmeticState() ? accessorySlot : cosmeticSlot);
                Pair<Component, PositionedRectangle> accessoryComponentData = ComponentUtils.slotAndToggle(accessorySlot, screen::slotAsComponent);
                accessoriesRowLayout.child((Component)accessoryComponentData.first());
                if (row < maxRowCount && screen.showCosmeticState()) {
                    rowButtons.add((PositionedRectangle)accessoryComponentData.second());
                }
                Pair<Component, PositionedRectangle> cosmeticComponentData = ComponentUtils.slotAndToggle(cosmeticSlot, screen::slotAsComponent);
                cosmeticRowLayout.child((Component)cosmeticComponentData.first());
                if (row >= maxRowCount || screen.showCosmeticState()) continue;
                rowButtons.add((PositionedRectangle)cosmeticComponentData.second());
            }
            if (!rowButtons.isEmpty()) {
                alternativeButtonChecks.add(CollectedPositionedRectangle.of((PositionedRectangle)(screen.showCosmeticState() ? cosmeticRowLayout : accessoriesRowLayout), rowButtons));
            }
            fullAccessoriesLayout.child((Component)accessoriesRowLayout);
            fullCosmeticsLayout.child((Component)cosmeticRowLayout);
            if (overMaxSlots) break;
        }
        return new Data(fullAccessoriesLayout, fullCosmeticsLayout, totalRowCount, maxRowCount, alternativeButtonChecks, new Vector2i(minimumWidth, minimumHeight), totalRowCount > gridSize);
    }

    public void build(int minimumWidth, int minimumHeight, boolean showScrollBar) {
        int minimumLayoutHeight = minimumHeight + 12;
        FlowLayout fullLayout = this.screen.showCosmeticState() ? this.fullCosmeticsLayout : this.fullAccessoriesLayout;
        int paddingValue = showScrollBar ? 3 : 0;
        fullLayout.padding(this.screen.mainWidgetPosition() ? Insets.left((int)paddingValue) : Insets.right((int)paddingValue));
        Object innerAccessoriesLayout = showScrollBar ? new ExtendedScrollContainer<FlowLayout>(ScrollContainer.ScrollDirection.VERTICAL, Sizing.fixed((int)(minimumWidth + 8 + 3)), Sizing.fixed((int)minimumHeight), fullLayout).strictMouseScrolling(!Accessories.config().screenOptions.allowSlotScrolling()).oppositeScrollbar(this.screen.mainWidgetPosition()).scrolledToCallback((container, prevOffset, scrollOffset) -> {
            if (Objects.equals(prevOffset, scrollOffset)) {
                return;
            }
            int rowIndex = prevOffset - scrollOffset < 0.0 ? (int)Math.floor(scrollOffset / 18.0) : (int)Math.ceil(scrollOffset / 18.0);
            Component patt0$temp = container.child();
            if (patt0$temp instanceof FlowLayout) {
                FlowLayout layout = (FlowLayout)patt0$temp;
                this.alternativeButtonChecks.clear();
                int maxRange = Math.min(rowIndex + this.maxRowCount, this.totalRowCount - 1);
                for (int i = rowIndex; i < maxRange; ++i) {
                    ParentComponent visibleRow = (ParentComponent)layout.childById(ParentComponent.class, "row_" + i);
                    ArrayList<PositionedRectangle> rowButtons = new ArrayList<PositionedRectangle>();
                    ComponentUtils.recursiveSearch(visibleRow, ButtonComponent.class, rowButtons::add);
                    this.alternativeButtonChecks.add(CollectedPositionedRectangle.of((PositionedRectangle)visibleRow, rowButtons));
                }
            }
        }).scrollbarThiccness(8).scrollbar(ScrollContainer.Scrollbar.vanilla()).fixedScrollbarLength(16).scrollStep(18).scrollbar(ComponentUtils.getScrollbarRenderer()) : Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)fullLayout);
        innerAccessoriesLayout.id("inner_accessories_container");
        FlowLayout accessoriesMainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(3).child((Component)innerAccessoriesLayout).horizontalAlignment(HorizontalAlignment.RIGHT).surface(ComponentUtils.getPanelSurface()).padding(Insets.of((int)6)).id("accessories_layout");
        if (showScrollBar) {
            this.child((Component)accessoriesMainLayout);
            return;
        }
        this.sizing(Sizing.content(), Sizing.fixed((int)minimumLayoutHeight));
        this.child((Component)accessoriesMainLayout);
        this.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.expand()));
    }

    @Override
    public void onCosmeticToggle(boolean showCosmeticState) {
        Consumer<FlowLayout> childSetter;
        this.alternativeButtonChecks.clear();
        BaseParentComponent container = (BaseParentComponent)this.childById(BaseParentComponent.class, "inner_accessories_container");
        int startingRowIndex = 0;
        if (container instanceof ExtendedScrollContainer) {
            ExtendedScrollContainer scrollContainer = (ExtendedScrollContainer)container;
            childSetter = layout -> scrollContainer.child((Component)layout);
        } else if (container instanceof FlowLayout) {
            FlowLayout flowLayout = (FlowLayout)container;
            childSetter = component -> {
                flowLayout.clearChildren();
                flowLayout.child((Component)component);
            };
        } else {
            return;
        }
        FlowLayout prevLayout = showCosmeticState ? this.fullAccessoriesLayout : this.fullCosmeticsLayout;
        for (int i = startingRowIndex; i < startingRowIndex + this.totalRowCount; ++i) {
            ParentComponent oldRow = (ParentComponent)prevLayout.childById(ParentComponent.class, "row_" + i);
            ComponentUtils.recursiveSearch(oldRow, AccessoriesExperimentalScreen.ExtendedSlotComponent.class, slotComponent -> this.screen.disableSlot(slotComponent.slot()));
        }
        FlowLayout newLayout = showCosmeticState ? this.fullCosmeticsLayout : this.fullAccessoriesLayout;
        int paddingValue = this.showScrollbar ? 3 : 0;
        newLayout.padding(this.screen.mainWidgetPosition() ? Insets.left((int)paddingValue) : Insets.right((int)paddingValue));
        childSetter.accept(newLayout);
        for (int i = startingRowIndex; i < startingRowIndex + this.totalRowCount; ++i) {
            ParentComponent newRow = (ParentComponent)newLayout.childById(ParentComponent.class, "row_" + i);
            if (i < this.maxRowCount) {
                ArrayList<PositionedRectangle> rowButtons = new ArrayList<PositionedRectangle>();
                ComponentUtils.recursiveSearch(newRow, ButtonComponent.class, rowButtons::add);
                this.alternativeButtonChecks.add(CollectedPositionedRectangle.of((PositionedRectangle)newRow, rowButtons));
            }
            ComponentUtils.recursiveSearch(newRow, AccessoriesExperimentalScreen.ExtendedSlotComponent.class, slotComponent -> this.screen.enableSlot(slotComponent.slot()));
        }
    }

    @Override
    @Nullable
    public Boolean isHovering_Logical(Slot slot, double mouseX, double mouseY) {
        for (PositionedRectangle child : this.alternativeButtonChecks) {
            if (!child.isInBoundingBox(mouseX, mouseY)) continue;
            return false;
        }
        return null;
    }

    public record Data(FlowLayout fullAccessoriesLayout, FlowLayout fullCosmeticsLayout, int totalRowCount, int maxRowCount, List<PositionedRectangle> alternativeButtonChecks, Vector2i minimumDimensions, Boolean showScrollbar) {
    }
}

