/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.GuiGraphicsUtils;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.ToggleButton;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.HolderProperty;
import io.wispforest.accessories.networking.holder.SyncHolderChange;
import io.wispforest.accessories.networking.server.MenuScroll;
import io.wispforest.accessories.pond.ContainerScreenExtension;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4i;

public class AccessoriesScreen
extends AbstractContainerScreen<AccessoriesMenu>
implements ContainerScreenExtension,
AccessoriesScreenBase<AccessoriesMenu> {
    private static final ResourceLocation SLOT = Accessories.of("textures/gui/theme/light/slot.png");
    private static final ResourceLocation ACCESSORIES_INVENTORY_LOCATION = Accessories.of("textures/gui/container/accessories_inventory.png");
    private static final ResourceLocation BACKGROUND_PATCH = Accessories.of("background_patch");
    private static final ResourceLocation SCROLL_BAR_PATCH = Accessories.of("scroll_bar_patch");
    private static final ResourceLocation SCROLL_BAR = Accessories.of("scroll_bar");
    private static final ResourceLocation HORIZONTAL_TABS = Accessories.of("textures/gui/container/horizontal_tabs_small.png");
    private static final WidgetSprites SPRITES_12X12 = new WidgetSprites(Accessories.of("widget/12x12/button"), Accessories.of("widget/12x12/button_disabled"), Accessories.of("widget/12x12/button_highlighted"));
    public static final WidgetSprites SPRITES_8X8 = new WidgetSprites(Accessories.of("widget/8x8/button"), Accessories.of("widget/8x8/button_disabled"), Accessories.of("widget/8x8/button_highlighted"));
    private static final ResourceLocation BACk_ICON = Accessories.of("widget/back");
    private static final ResourceLocation LINE_HIDDEN = Accessories.of("widget/line_hidden");
    private static final ResourceLocation LINE_SHOWN = Accessories.of("widget/line_shown");
    private static final ResourceLocation UNUSED_SLOTS_HIDDEN = Accessories.of("widget/unused_slots_hidden");
    private static final ResourceLocation UNUSED_SLOTS_SHOWN = Accessories.of("widget/unused_slots_shown");
    private final Map<AccessoriesInternalSlot, ToggleButton> cosmeticButtons = new LinkedHashMap<AccessoriesInternalSlot, ToggleButton>();
    private int currentTabPage = 1;
    private int scrollBarHeight = 0;
    private boolean isScrolling = false;
    private static final int upperPadding = 8;
    private Button backButton = null;
    private Button cosmeticToggleButton = null;
    private Button linesToggleButton = null;
    private Button unusedSlotsToggleButton = null;
    private Button uniqueSlotsToggleButton = null;
    private Button tabUpButton = null;
    private Button tabDownButton = null;

    public AccessoriesScreen(AccessoriesMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, (Component)Component.empty());
        this.titleLabelX = 97;
        this.inventoryLabelX = 42069;
    }

    public int getPanelHeight() {
        return this.getPanelHeight(8);
    }

    public int getPanelHeight(int upperPadding) {
        return 14 + Math.min(((AccessoriesMenu)this.menu).totalSlots, 8) * 18 + upperPadding;
    }

    public int getPanelWidth() {
        int width = 44;
        if (((AccessoriesMenu)this.menu).isCosmeticsOpen()) {
            width += 20;
        }
        if (!((AccessoriesMenu)this.menu).overMaxVisibleSlots) {
            width -= 12;
        }
        return width;
    }

    public int getStartingPanelX() {
        int x = this.leftPos - (((AccessoriesMenu)this.menu).isCosmeticsOpen() ? 72 : 52);
        if (!((AccessoriesMenu)this.menu).overMaxVisibleSlots) {
            x += 12;
        }
        return x;
    }

    public int leftPos() {
        return this.leftPos;
    }

    public int topPos() {
        return this.topPos;
    }

    @Override
    public final LivingEntity targetEntityDefaulted() {
        LivingEntity targetEntity = ((AccessoriesMenu)this.menu).targetEntity();
        return targetEntity != null ? targetEntity : this.minecraft.player;
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int x = this.getStartingPanelX() + 13;
        int y = this.topPos + 7 + 8;
        int height = this.getPanelHeight() - 22;
        int width = 8;
        return ((AccessoriesMenu)this.menu).overMaxVisibleSlots && mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean bl = super.mouseClicked(mouseX, mouseY, button);
        if (this.getFocused() instanceof Button) {
            this.clearFocus();
        }
        if (this.insideScrollbar(mouseX, mouseY)) {
            this.isScrolling = true;
            return true;
        }
        if (Accessories.config().screenOptions.showGroupTabs() && ((AccessoriesMenu)this.menu).maxScrollableIndex() > 0) {
            int x = this.getStartingPanelX();
            int y = this.topPos;
            for (SlotGroupData value : this.getGroups(x, y).values()) {
                if (!value.isInBounds((int)Math.round(mouseX), (int)Math.round(mouseY))) continue;
                int index = value.startingIndex;
                if (index > ((AccessoriesMenu)this.menu).maxScrollableIndex()) {
                    index = ((AccessoriesMenu)this.menu).maxScrollableIndex();
                }
                if (index == ((AccessoriesMenu)this.menu).scrolledIndex) break;
                AccessoriesNetworking.sendToServer(new MenuScroll(index, false));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                break;
            }
        }
        return bl;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.insideScrollbar(mouseX, mouseY) && button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        AccessoriesInternalSlot slot2;
        Slot slot3;
        int leftPos = this.leftPos;
        int topPos = this.topPos;
        guiGraphics.blit(ACCESSORIES_INVENTORY_LOCATION, leftPos, topPos, 0, 0, this.imageWidth, this.imageHeight);
        Vector2i scissorStart = new Vector2i(leftPos + 26, topPos + 8);
        Vector2i scissorEnd = new Vector2i(leftPos + 26 + 124, topPos + 8 + 70);
        Vector2i size = new Vector2i((scissorEnd.x - scissorStart.x) / 2, scissorEnd.y - scissorStart.y);
        SCISSOR_BOX.set(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        AccessoriesScreenBase.togglePositionCollection();
        AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.setValue(true);
        IS_RENDERING_LINE_TARGET.setValue(true);
        this.renderEntityInInventoryFollowingMouseRotated(guiGraphics, scissorStart, size, scissorStart, scissorEnd, mouseX, mouseY, 0.0f);
        IS_RENDERING_LINE_TARGET.setValue(false);
        this.renderEntityInInventoryFollowingMouseRotated(guiGraphics, new Vector2i((Vector2ic)scissorStart).add(size.x, 0), size, scissorStart, scissorEnd, mouseX, mouseY, 180.0f);
        AccessoriesScreenBase.IS_RENDERING_UI_ENTITY.setValue(false);
        COLLECT_ACCESSORY_POSITIONS.setValue(false);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 0.0f);
        int x = this.getStartingPanelX();
        int y = this.topPos;
        int height = this.getPanelHeight();
        int width = this.getPanelWidth();
        GuiGraphicsUtils.blitSpriteBatched(guiGraphics, BACKGROUND_PATCH, x + 6, y, width, height);
        if (((AccessoriesMenu)this.menu).overMaxVisibleSlots) {
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, SCROLL_BAR_PATCH, x + 13, y + 7 + 8, 8, height - 22);
        }
        pose.popPose();
        pose.pushPose();
        pose.translate(-1.0f, -1.0f, 0.0f);
        GuiGraphicsUtils.batched(guiGraphics, SLOT, ((AccessoriesMenu)this.menu).slots, (bufferBuilder, poseStack, slot) -> {
            if (!(slot.container instanceof ExpandedSimpleContainer) || !slot.isActive()) {
                return;
            }
            GuiGraphicsUtils.blit(bufferBuilder, poseStack, slot.x + this.leftPos, slot.y + this.topPos, 18);
        });
        if (this.getHoveredSlot() != null && (slot3 = this.getHoveredSlot()) instanceof AccessoriesInternalSlot && (slot2 = (AccessoriesInternalSlot)slot3).isActive() && !slot2.getItem().isEmpty() && NOT_VERY_NICE_POSITIONS.containsKey(slot2.accessoriesContainer.getSlotName() + slot2.getContainerSlot())) {
            ACCESSORY_POSITIONS.add((Vector3d)NOT_VERY_NICE_POSITIONS.get(slot2.accessoriesContainer.getSlotName() + slot2.getContainerSlot()));
            String positionKey = slot2.accessoriesContainer.getSlotName() + slot2.getContainerSlot();
            Vector3d vec = NOT_VERY_NICE_POSITIONS.getOrDefault(positionKey, null);
            if (!slot2.isCosmetic && vec != null && Accessories.config().screenOptions.hoveredOptions.line()) {
                Vector3d start = new Vector3d((double)(slot2.x + this.leftPos + 17), (double)(slot2.y + this.topPos + 9), 5000.0);
                Vector3d vec3 = vec.add(0.0, 0.0, 5000.0);
                ACCESSORY_LINES.add(Pair.of((Object)start, (Object)vec3));
            }
        }
        pose.popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int index;
        if ((this.insideScrollbar(mouseX, mouseY) || Accessories.config().screenOptions.allowSlotScrolling() && this.hoveredSlot instanceof AccessoriesInternalSlot) && (index = (int)Math.max(Math.min(-scrollY + (double)((AccessoriesMenu)this.menu).scrolledIndex, (double)((AccessoriesMenu)this.menu).maxScrollableIndex()), 0.0)) != ((AccessoriesMenu)this.menu).scrolledIndex) {
            AccessoriesNetworking.sendToServer(new MenuScroll(index, false));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int patchYOffset = this.topPos + 7 + 8;
            int height = this.getPanelHeight();
            ((AccessoriesMenu)this.menu).smoothScroll = Mth.clamp((float)((float)(mouseY - (double)patchYOffset) / ((float)height - 22.0f)), (float)0.0f, (float)1.0f);
            int index = Math.round(((AccessoriesMenu)this.menu).smoothScroll * (float)((AccessoriesMenu)this.menu).maxScrollableIndex());
            if (index != ((AccessoriesMenu)this.menu).scrolledIndex) {
                AccessoriesNetworking.sendToServer(new MenuScroll(index, true));
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        for (ToggleButton cosmeticButton : this.cosmeticButtons.values()) {
            cosmeticButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        int x = this.getStartingPanelX();
        int y = this.topPos;
        int panelHeight = this.getPanelHeight();
        if (((AccessoriesMenu)this.menu).overMaxVisibleSlots) {
            int startingY = y + 8 + 8;
            startingY = (int)((float)startingY + ((AccessoriesMenu)this.menu).smoothScroll * (float)(panelHeight - 24 - this.scrollBarHeight));
            GuiGraphicsUtils.blitSpriteBatched(guiGraphics, SCROLL_BAR, x + 14, startingY, 6, this.scrollBarHeight);
        }
        PoseStack pose = guiGraphics.pose();
        if (Accessories.config().screenOptions.showGroupTabs()) {
            for (Map.Entry<SlotGroup, SlotGroupData> entry : this.getGroups(x, y).entrySet()) {
                SlotGroup group = entry.getKey();
                SlotGroupData pair = entry.getValue();
                Vector4i vector = pair.dimensions();
                int v = pair.isSelected() ? vector.w : vector.w * 3;
                guiGraphics.blit(HORIZONTAL_TABS, vector.x, vector.y, 0.0f, (float)v, vector.z, vector.w, 19, vector.w * 4);
                pose.pushPose();
                pose.translate((float)(vector.x + 3), (float)(vector.y + 3), 0.0f);
                pose.translate(1.0f, 1.0f, 0.0f);
                if (pair.isSelected) {
                    pose.translate(2.0f, 0.0f, 0.0f);
                }
                guiGraphics.blitSprite(group.icon(), 0, 0, 0, 8, 8);
                pose.popPose();
            }
        }
        if (Accessories.config().screenOptions.hoveredOptions.clickbait()) {
            ACCESSORY_POSITIONS.forEach(pos -> guiGraphics.blitSprite(Accessories.of("highlight/clickbait"), (int)pos.x - 128, (int)pos.y - 128, 100, 256, 256));
            ACCESSORY_POSITIONS.clear();
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!ACCESSORY_LINES.isEmpty() && Accessories.config().screenOptions.hoveredOptions.line()) {
            VertexConsumer buf = guiGraphics.bufferSource().getBuffer((RenderType)RenderType.LINES);
            PoseStack.Pose lastPose = guiGraphics.pose().last();
            for (Pair line : ACCESSORY_LINES) {
                Vector3f normalVec = ((Vector3d)line.second()).sub((Vector3dc)line.first(), new Vector3d()).normalize().get(new Vector3f());
                double segments = Math.max(10, (int)(((Vector3d)line.first()).distance((Vector3dc)line.second()) * 10.0) / 100);
                double movement = (double)System.currentTimeMillis() / ((segments *= 2.0) * 1000.0) % 1.0;
                double delta = movement % (2.0 / segments) % segments;
                Vector3f firstVec = ((Vector3d)line.first()).get(new Vector3f());
                if (delta > 0.05) {
                    buf.addVertex(firstVec).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                    Vector3f pos2 = new Vector3d(Mth.lerp((double)(delta - 0.05), (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.lerp((double)(delta - 0.05), (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.lerp((double)(delta - 0.05), (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    buf.addVertex(pos2).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                }
                int i = 0;
                while ((double)i < segments / 2.0) {
                    double delta1 = ((double)(i * 2) / segments + movement) % 1.0;
                    double delta2 = ((double)(i * 2 + 1) / segments + movement) % 1.0;
                    Vector3f pos1 = new Vector3d(Mth.lerp((double)delta1, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.lerp((double)delta1, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.lerp((double)delta1, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)).get(new Vector3f());
                    Vector3f pos2 = (delta2 > delta1 ? new Vector3d(Mth.lerp((double)delta2, (double)((Vector3d)line.first()).x, (double)((Vector3d)line.second()).x), Mth.lerp((double)delta2, (double)((Vector3d)line.first()).y, (double)((Vector3d)line.second()).y), Mth.lerp((double)delta2, (double)((Vector3d)line.first()).z, (double)((Vector3d)line.second()).z)) : (Vector3d)line.second()).get(new Vector3f());
                    buf.addVertex(pos1).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                    buf.addVertex(pos2).setColor(255, 255, 255, 255).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(lastPose, normalVec.x, normalVec.y, normalVec.z);
                    ++i;
                }
            }
            this.minecraft.renderBuffers().bufferSource().endBatch((RenderType)RenderType.LINES);
            ACCESSORY_LINES.clear();
        }
    }

    protected void init() {
        if (!((AccessoriesMenu)this.menu).isValidMenu()) {
            Minecraft.getInstance().setScreen((Screen)new ErrorScreen((Component)Component.literal((String)"Accessories Screen Opening Error!"), (Component)Component.literal((String)"Unable to open Accessories Screen due to desync with the Server!")));
            return;
        }
        super.init();
        this.currentTabPage = 1;
        this.cosmeticButtons.clear();
        this.backButton = (Button)((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), btn -> this.switchToBaseInventory()).bounds(this.leftPos + 141, this.topPos + 9, 8, 8).tooltip(Tooltip.create((Component)Component.translatable((String)Accessories.translationKey("back.screen")))).build())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.blitSprite(SPRITES_8X8.get(button.active, button.isHoveredOrFocused()), x, y, width, height);
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate(0.5, 0.5, 0.0);
            guiGraphics.blitSprite(BACk_ICON, x, y, width - 1, height - 1);
            pose.popPose();
            return true;
        });
        boolean cosmeticsOpen = ((AccessoriesMenu)this.menu).isCosmeticsOpen();
        this.cosmeticToggleButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), btn -> AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.COSMETIC_PROP, ((AccessoriesMenu)this.getMenu()).owner(), bl -> bl == false))).tooltip(AccessoriesScreen.cosmeticsToggleTooltip(cosmeticsOpen)).bounds(this.leftPos - 27 + (cosmeticsOpen ? -20 : 0), this.topPos + 7, cosmeticsOpen ? 38 : 18, 6).build());
        int btnOffset = this.topPos + 7;
        this.unusedSlotsToggleButton = (Button)((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), btn -> AccessoriesNetworking.sendToServer(SyncHolderChange.of(HolderProperty.UNUSED_PROP, ((AccessoriesMenu)this.getMenu()).owner(), bl -> bl == false))).tooltip(AccessoriesScreen.unusedSlotsToggleButton(((AccessoriesMenu)this.menu).areUnusedSlotsShown())).bounds(this.leftPos + 154, btnOffset, 12, 12).build())).adjustRendering((button, guiGraphics, sprite, x, y, width, height) -> {
            guiGraphics.blitSprite(SPRITES_12X12.get(button.active, button.isHoveredOrFocused()), x, y, width, height);
            guiGraphics.blitSprite(((AccessoriesMenu)this.menu).areUnusedSlotsShown() ? UNUSED_SLOTS_SHOWN : UNUSED_SLOTS_HIDDEN, x, y, width, height);
            return true;
        });
        btnOffset += 15;
        int accessoriesSlots = 0;
        for (Slot slot : ((AccessoriesMenu)this.menu).slots) {
            if (!(slot instanceof AccessoriesInternalSlot)) continue;
            AccessoriesInternalSlot accessoriesSlot = (AccessoriesInternalSlot)slot;
            if (accessoriesSlot.isCosmetic) continue;
            ToggleButton slotButton = ToggleButton.ofSlot(slot.x + this.leftPos + 13, slot.y + this.topPos - 2, 300, accessoriesSlot);
            slotButton.visible = accessoriesSlot.isActive();
            slotButton.active = accessoriesSlot.isActive();
            this.cosmeticButtons.put(accessoriesSlot, (ToggleButton)this.addWidget((GuiEventListener)slotButton));
            ++accessoriesSlots;
        }
        ((AccessoriesMenu)this.menu).setScrollEvent(this::updateAccessoryToggleButtons);
        this.scrollBarHeight = Mth.lerpInt((float)Math.min((float)accessoriesSlots / 20.0f, 1.0f), (int)101, (int)31);
        if (this.scrollBarHeight % 2 == 0) {
            ++this.scrollBarHeight;
        }
    }

    private void onTabPageChange(boolean isDown) {
    }

    @Override
    public void onHolderChange(String key) {
        switch (key) {
            case "lines": {
                this.updateLinesButton();
                break;
            }
            case "cosmetic": {
                this.updateCosmeticToggleButton();
                break;
            }
            case "unused_slots": {
                this.updateUnusedSlotToggleButton();
            }
        }
    }

    public void updateLinesButton() {
    }

    public void updateCosmeticToggleButton() {
        Button btn = this.cosmeticToggleButton;
        btn.setWidth(((AccessoriesMenu)this.menu).isCosmeticsOpen() ? 38 : 18);
        btn.setX(btn.getX() + (((AccessoriesMenu)this.menu).isCosmeticsOpen() ? -20 : 20));
        btn.setTooltip(AccessoriesScreen.cosmeticsToggleTooltip(((AccessoriesMenu)this.menu).isCosmeticsOpen()));
    }

    public void updateUnusedSlotToggleButton() {
        this.unusedSlotsToggleButton.setTooltip(AccessoriesScreen.unusedSlotsToggleButton(((AccessoriesMenu)this.menu).areUnusedSlotsShown()));
        ((AccessoriesMenu)this.menu).reopenMenu();
    }

    public void updateAccessoryToggleButtons() {
        for (Map.Entry<AccessoriesInternalSlot, ToggleButton> entry : this.cosmeticButtons.entrySet()) {
            AccessoriesInternalSlot accessoriesSlot = entry.getKey();
            ToggleButton btn = entry.getValue();
            if (!accessoriesSlot.isActive()) {
                btn.active = false;
                btn.visible = false;
                continue;
            }
            btn.setTooltip(AccessoriesScreen.toggleTooltip(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.getContainerSlot())));
            btn.setX(accessoriesSlot.x + this.leftPos + 13);
            btn.setY(accessoriesSlot.y + this.topPos - 2);
            btn.toggled(accessoriesSlot.accessoriesContainer.shouldRender(accessoriesSlot.getContainerSlot()));
            btn.active = true;
            btn.visible = true;
        }
    }

    private static Tooltip cosmeticsToggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("slot.cosmetics", value);
    }

    private static Tooltip linesToggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("lines", value);
    }

    private static Tooltip unusedSlotsToggleButton(boolean value) {
        return AccessoriesScreen.createToggleTooltip("unused_slots", value);
    }

    private static Tooltip uniqueSlotsToggleButton(boolean value) {
        return AccessoriesScreen.createToggleTooltip("unique_slots", value);
    }

    private static Tooltip toggleTooltip(boolean value) {
        return AccessoriesScreen.createToggleTooltip("display", value);
    }

    private static Tooltip createToggleTooltip(String type, boolean value) {
        String key = type + ".toggle." + (!value ? "show" : "hide");
        return Tooltip.create((Component)Component.translatable((String)Accessories.translationKey(key)));
    }

    @Override
    @Nullable
    public Boolean isHovering_Logical(Slot slot, double mouseX, double mouseY) {
        for (GuiEventListener child : this.children()) {
            ToggleButton btn;
            if (!(child instanceof ToggleButton) || !(btn = (ToggleButton)child).isMouseOver(mouseX, mouseY)) continue;
            return false;
        }
        return ContainerScreenExtension.super.isHovering_Logical(slot, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        Slot slot = this.hoveredSlot;
        if (slot instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot2 = (AccessoriesInternalSlot)slot;
            AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(true);
            if (slot2.getItem().isEmpty() && slot2.accessoriesContainer.slotType() != null) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, slot2.getTooltipData(), Optional.empty(), x, y);
                return;
            }
        }
        if (Accessories.config().screenOptions.showGroupTabs()) {
            int panelX = this.getStartingPanelX();
            int panelY = this.topPos;
            for (Map.Entry<SlotGroup, SlotGroupData> entry : this.getGroups(panelX, panelY).entrySet()) {
                if (!entry.getValue().isInBounds(x, y)) continue;
                ArrayList<MutableComponent> tooltipData = new ArrayList<MutableComponent>();
                SlotGroup group = entry.getKey();
                tooltipData.add(Component.translatable((String)group.translation()));
                if (UniqueSlotHandling.isUniqueGroup(group.name(), true)) {
                    tooltipData.add(Component.literal((String)group.name()).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
                }
                guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltipData, Optional.empty(), x, y);
                break;
            }
        }
        super.renderTooltip(guiGraphics, x, y);
        AccessoriesScreenBase.FORCE_TOOLTIP_LEFT.setValue(false);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int x, int y, int mouseButton) {
        int leftPos = this.leftPos;
        int topPos = this.topPos;
        boolean insideMainPanel = mouseX >= (double)leftPos && mouseX <= (double)(leftPos + this.imageWidth) && mouseY >= (double)topPos && mouseY <= (double)(topPos + this.imageHeight);
        int sidePanelX = this.getStartingPanelX();
        int sidePanelY = topPos;
        boolean insideSidePanel = mouseX >= (double)sidePanelX && mouseX <= (double)(sidePanelX + this.getPanelWidth() + this.imageWidth) && mouseY >= (double)sidePanelY && mouseY <= (double)(sidePanelY + this.getPanelHeight());
        boolean insideGroupPanel = false;
        if (Accessories.config().screenOptions.showGroupTabs() && ((AccessoriesMenu)this.menu).maxScrollableIndex() > 0) {
            for (SlotGroupData value : this.getGroups(sidePanelX, sidePanelY).values()) {
                if (!value.isInBounds((int)Math.round(mouseX), (int)Math.round(mouseY))) continue;
                insideGroupPanel = true;
                break;
            }
        }
        return !insideMainPanel && !insideSidePanel && !insideGroupPanel;
    }

    public static int tabPageCount() {
        List<SlotGroup> groups = SlotGroupLoader.INSTANCE.getGroups(true, true);
        return (int)Math.ceil((float)groups.size() / 9.0f);
    }

    private Map<SlotGroup, SlotGroupData> getGroups(int x, int y) {
        List<SlotGroup> groups = ((AccessoriesMenu)this.getMenu()).validGroups().stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).toList();
        if (AccessoriesScreen.tabPageCount() > 1) {
            int lowerBound = (this.currentTabPage - 1) * 9;
            int upperBound = lowerBound + 9;
            if (upperBound > groups.size()) {
                upperBound = groups.size();
            }
            groups = groups.subList(lowerBound, upperBound);
        }
        int bottomIndex = ((AccessoriesMenu)this.menu).scrolledIndex;
        int upperIndex = bottomIndex + 8 - 1;
        Range scrollRange = Range.between((Object)bottomIndex, (Object)upperIndex, Integer::compareTo);
        LivingEntity targetEntity = this.targetEntityDefaulted();
        Map<String, AccessoriesContainer> containers = targetEntity.accessoriesCapability().getContainers();
        HashMap<String, Integer> slotToSize = new HashMap<String, Integer>();
        for (SlotType slotType : EntitySlotLoader.getEntitySlots(targetEntity).values()) {
            Object container;
            Set<SlotType> usedSlots = ((AccessoriesMenu)this.getMenu()).usedSlots();
            if (usedSlots != null && !usedSlots.contains(slotType) || (container = containers.get(slotType.name())) == null) continue;
            slotToSize.put(slotType.name(), container.getAccessories().getContainerSize());
        }
        int currentIndexOffset = 0;
        HashMap<SlotGroup, Integer> groupToIndex = new HashMap<SlotGroup, Integer>();
        HashSet<String> selectedGroup = new HashSet<String>();
        for (SlotGroup group : groups) {
            int groupSize = slotToSize.entrySet().stream().filter(entry -> group.slots().contains(entry.getKey())).mapToInt(Map.Entry::getValue).sum();
            if (groupSize <= 0) continue;
            int groupMinIndex = currentIndexOffset;
            int groupMaxIndex = groupMinIndex + groupSize - 1;
            Range groupRange = Range.between((Object)groupMinIndex, (Object)groupMaxIndex, Integer::compareTo);
            if (groupRange.isOverlappedBy(scrollRange)) {
                selectedGroup.add(group.name());
            }
            groupToIndex.put(group, groupMinIndex);
            currentIndexOffset += groupSize;
        }
        int maxHeight = this.getPanelHeight() - 4;
        int width = 19;
        int height = 16;
        int tabY = y + 4;
        int tabX = x - (width - 10);
        int yOffset = 0;
        HashMap<SlotGroup, SlotGroupData> groupValues = new HashMap<SlotGroup, SlotGroupData>();
        for (SlotGroup group : groups) {
            if (yOffset + height > maxHeight) break;
            boolean selected = selectedGroup.contains(group.name());
            int xOffset = selected ? 0 : 2;
            Integer index = (Integer)groupToIndex.get(group);
            if (index == null) continue;
            groupValues.put(group, new SlotGroupData(new Vector4i(tabX + xOffset, tabY + yOffset, width - xOffset, height), selected, index));
            yOffset += height + 1;
        }
        return groupValues;
    }

    private static SlotGroupImpl copy(SlotGroup group) {
        return new SlotGroupImpl(group.name() + "1", group.order(), group.slots(), group.icon());
    }

    private void renderEntityInInventoryFollowingMouseRotated(GuiGraphics guiGraphics, Vector2i pos, Vector2i size, Vector2i scissorStart, Vector2i scissorEnd, float mouseX, float mouseY, float rotation) {
        int scale = 30;
        float yOffset = 0.0625f;
        LivingEntity entity = this.targetEntityDefaulted();
        float f = (float)(pos.x + pos.x + size.x) / 2.0f;
        float g = (float)(pos.y + pos.y + size.y) / 2.0f;
        guiGraphics.enableScissor(scissorStart.x, scissorStart.y, scissorEnd.x, scissorEnd.y);
        float h = (float)Math.atan(((float)(scissorStart.x + scissorStart.x + size.x) / 2.0f - mouseX) / 40.0f);
        float i = (float)Math.atan(((float)(scissorStart.y + scissorStart.y + size.y) / 2.0f - mouseY) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)((double)rotation * (Math.PI / 180)));
        Quaternionf quaternionf2 = new Quaternionf().rotateX(i * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float j = entity.yBodyRot;
        float k = entity.getYRot();
        float l = entity.getXRot();
        float m = entity.yHeadRotO;
        float n = entity.yHeadRot;
        entity.yBodyRot = 180.0f + h * 30.0f;
        entity.setYRot(180.0f + h * 40.0f);
        entity.setXRot(-i * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        Vector3f vector3f = new Vector3f(0.0f, entity.getBbHeight() / 2.0f + yOffset, 0.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)f, (float)g, (float)scale, (Vector3f)vector3f, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (LivingEntity)entity);
        entity.yBodyRot = j;
        entity.setYRot(k);
        entity.setXRot(l);
        entity.yHeadRotO = m;
        entity.yHeadRot = n;
        guiGraphics.disableScissor();
    }

    @Override
    public Slot getHoveredSlot() {
        return this.hoveredSlot;
    }

    private record SlotGroupData(Vector4i dimensions, boolean isSelected, int startingIndex) {
        private boolean isInBounds(int x, int y) {
            return x > this.dimensions.x && y > this.dimensions.y && x < this.dimensions.x + this.dimensions.z && y < this.dimensions.y + this.dimensions.w;
        }
    }
}

