/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelibarmor.common.model.AzBakedModel;
import mod.azure.azurelibarmor.common.render.AzLayerRenderer;
import mod.azure.azurelibarmor.common.render.AzModelRenderer;
import mod.azure.azurelibarmor.common.render.AzPhasedRenderer;
import mod.azure.azurelibarmor.common.render.AzRendererConfig;
import mod.azure.azurelibarmor.common.render.AzRendererPipelineContext;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.Nullable;

public abstract class AzRendererPipeline<K, T>
implements AzPhasedRenderer<K, T> {
    protected final AzRendererConfig<K, T> config;
    private final AzRendererPipelineContext<K, T> context;
    private final AzLayerRenderer<K, T> layerRenderer;
    private final AzModelRenderer<K, T> modelRenderer;

    protected AzRendererPipeline(AzRendererConfig<K, T> config) {
        this.config = config;
        this.context = this.createContext(this);
        this.layerRenderer = this.createLayerRenderer(config);
        this.modelRenderer = this.createModelRenderer(this.layerRenderer);
    }

    protected abstract AzRendererPipelineContext<K, T> createContext(AzRendererPipeline<K, T> var1);

    protected abstract AzModelRenderer<K, T> createModelRenderer(AzLayerRenderer<K, T> var1);

    protected abstract AzLayerRenderer<K, T> createLayerRenderer(AzRendererConfig<K, T> var1);

    protected abstract void updateAnimatedTextureFrame(T var1);

    public void render(PoseStack poseStack, AzBakedModel model, T animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        renderType = this.context.getDefaultRenderType(animatable, this.config.textureLocation(this.context.currentEntity, animatable), bufferSource, partialTick, this.config.getRenderType(this.context.currentEntity, animatable), this.config.alpha(animatable));
        this.context.populate(animatable, model, bufferSource, packedLight, partialTick, poseStack, renderType, buffer);
        poseStack.pushPose();
        this.preRender(this.context, false);
        this.layerRenderer.preApplyRenderLayers(this.context);
        this.modelRenderer.cacheTexture(this.context);
        this.modelRenderer.render(this.context, false);
        this.modelRenderer.clearCacheTexture();
        this.layerRenderer.applyRenderLayers(this.context);
        this.postRender(this.context, false);
        poseStack.popPose();
        this.renderFinal(this.context);
        this.doPostRenderCleanup(this.context);
    }

    public void reRender(AzRendererPipelineContext<K, T> context) {
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        this.preRender(context, true);
        this.modelRenderer.render(context, true);
        this.postRender(context, true);
        poseStack.popPose();
    }

    protected void renderFinal(AzRendererPipelineContext<K, T> context) {
    }

    protected void doPostRenderCleanup(AzRendererPipelineContext<K, T> context) {
    }

    protected void scaleModelForRender(AzRendererPipelineContext<K, T> context, float widthScale, float heightScale, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            PoseStack poseStack = context.poseStack();
            poseStack.scale(widthScale, heightScale, widthScale);
        }
    }

    public AzRendererConfig<K, T> config() {
        return this.config;
    }

    public AzRendererPipelineContext<K, T> context() {
        return this.context;
    }
}

