/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import mod.azure.azurelibarmor.common.cache.texture.AutoGlowingTexture;
import mod.azure.azurelibarmor.common.platform.Services;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public abstract class AzAbstractTexture
extends SimpleTexture {
    protected static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEntityTranslucentEmissiveShader);
    protected static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    protected static final BiFunction<ResourceLocation, Boolean, RenderType> GLOWING_RENDER_TYPE = Util.memoize((texture, isGlowing) -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.create((String)"az_glowing_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(TRANSPARENCY_STATE).setOverlayState(new RenderStateShard.OverlayStateShard(true)).setWriteMaskState(WRITE_MASK).createCompositeState(isGlowing.booleanValue()));
    });
    protected static final String APPENDIX = "_glowmask";

    public AzAbstractTexture(ResourceLocation location) {
        super(location);
    }

    public static void onRenderThread(RenderCall renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((RenderCall)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected static void generateTexture(ResourceLocation texturePath, Consumer<TextureManager> textureManagerConsumer) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            throw new IllegalThreadStateException("Texture loading called outside of the render thread! This should DEFINITELY not be happening.");
        }
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        if (!(textureManager.getTexture(texturePath, (AbstractTexture)MissingTextureAtlasSprite.getTexture()) instanceof AzAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public static void uploadSimple(int texture, NativeImage image, boolean blur, boolean clamp) {
        TextureUtil.prepareImage((int)texture, (int)0, (int)image.getWidth(), (int)image.getHeight());
        image.upload(0, 0, 0, 0, 0, image.getWidth(), image.getHeight(), blur, clamp, false, true);
    }

    public static ResourceLocation appendToPath(ResourceLocation location, String suffix) {
        String path = location.getPath();
        int i = path.lastIndexOf(46);
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(path.substring(0, i) + suffix + path.substring(i)));
    }

    public void load(ResourceManager resourceManager) throws IOException {
        RenderCall renderCall = this.loadTexture(resourceManager, Minecraft.getInstance());
        if (renderCall == null) {
            return;
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall((RenderCall)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected void printDebugImageToDisk(ResourceLocation id, NativeImage newImage) {
        try {
            File file = new File(Services.PLATFORM.getGameDir().toFile(), "GeoTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, id.getPath().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            newImage.writeToFile(file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    protected abstract RenderCall loadTexture(ResourceManager var1, Minecraft var2) throws IOException;

    public static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = AzAbstractTexture.appendToPath(baseResource, APPENDIX);
        AzAbstractTexture.generateTexture(path, textureManager -> textureManager.register(path, (AbstractTexture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    public static RenderType getRenderType(ResourceLocation texture) {
        return GLOWING_RENDER_TYPE.apply(AzAbstractTexture.getEmissiveResource(texture), false);
    }

    public static RenderType getOutlineRenderType(ResourceLocation texture) {
        return GLOWING_RENDER_TYPE.apply(AzAbstractTexture.getEmissiveResource(texture), true);
    }
}

