/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.animation.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.azure.azurelibarmor.common.animation.primitive.AzBakedAnimations;
import mod.azure.azurelibarmor.common.cache.AzResourceCache;
import mod.azure.azurelibarmor.common.loading.FileLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class AzBakedAnimationCache
extends AzResourceCache {
    private static final AzBakedAnimationCache INSTANCE = new AzBakedAnimationCache();
    private final Map<ResourceLocation, AzBakedAnimations> bakedAnimations = new Object2ObjectOpenHashMap();

    public static AzBakedAnimationCache getInstance() {
        return INSTANCE;
    }

    private AzBakedAnimationCache() {
    }

    public CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, ResourceManager resourceManager) {
        return this.loadResources(backgroundExecutor, resourceManager, "animations", resource -> FileLoader.loadAzAnimationsFile(resource, resourceManager), this.bakedAnimations::put);
    }

    @Nullable
    public AzBakedAnimations getNullable(ResourceLocation resourceLocation) {
        return this.bakedAnimations.get(resourceLocation);
    }
}

