/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import me.jddev0.ep.screen.base.IEnergyStorageMenu;
import me.jddev0.ep.screen.base.IUpgradeModuleMenu;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EnergyStorageContainerScreen<T extends AbstractContainerMenu>
extends EnergizedPowerBaseContainerScreen<T> {
    protected final ResourceLocation TEXTURE;
    protected int energyMeterX = 8;
    protected int energyMeterY = 17;
    protected int energyMeterWidth = 16;
    protected int energyMeterHeight = 52;
    protected int energyMeterU = 0;
    protected int energyMeterV = 0;
    protected String energyPerTickBarTooltipComponentID = "tooltip.energizedpower.energy_consumption_per_tick.txt";
    protected final String energyIndicatorBarTooltipComponentID;

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent) {
        this(menu, inventory, titleComponent, (String)null);
    }

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, String energyIndicatorBarTooltipComponentID) {
        this(menu, inventory, titleComponent, energyIndicatorBarTooltipComponentID, EPAPI.id("textures/gui/container/generic_energy.png"));
    }

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, ResourceLocation texture) {
        this(menu, inventory, titleComponent, null, texture);
    }

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, String energyIndicatorBarTooltipComponentID, ResourceLocation texture) {
        super(menu, inventory, titleComponent);
        this.TEXTURE = texture;
        this.energyIndicatorBarTooltipComponentID = energyIndicatorBarTooltipComponentID;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (!((IUpgradeModuleMenu)this.menu).isInUpgradeModuleView()) {
            guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
            this.renderEnergyMeter(guiGraphics, x, y);
            this.renderEnergyPerTickBar(guiGraphics, x, y);
            this.renderEnergyIndicatorBar(guiGraphics, x, y);
        }
    }

    protected void renderEnergyMeter(GuiGraphics guiGraphics, int x, int y) {
        int pos = ((IEnergyStorageMenu)this.menu).getScaledEnergyMeterPos(this.energyMeterHeight);
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + this.energyMeterX, y + this.energyMeterY + this.energyMeterHeight - pos, this.energyMeterU, this.energyMeterV + this.energyMeterHeight - pos, this.energyMeterWidth, pos);
    }

    protected void renderEnergyIndicatorBar(GuiGraphics guiGraphics, int x, int y) {
        int pos = ((IEnergyStorageMenu)this.menu).getScaledEnergyIndicatorBarPos(this.energyMeterHeight);
        if (pos > 0) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + this.energyMeterX, y + this.energyMeterY + this.energyMeterHeight - pos, this.energyMeterU, this.energyMeterV + this.energyMeterHeight, this.energyMeterWidth, 1);
        }
    }

    protected void renderEnergyPerTickBar(GuiGraphics guiGraphics, int x, int y) {
        int pos = ((IEnergyStorageMenu)this.menu).getScaledEnergyPerTickBarPos(this.energyMeterHeight);
        if (pos > 0) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + this.energyMeterX, y + this.energyMeterY + this.energyMeterHeight - pos, this.energyMeterU, this.energyMeterV + this.energyMeterHeight + 1, this.energyMeterWidth, 1);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!((IUpgradeModuleMenu)this.menu).isInUpgradeModuleView() && this.isHovering(this.energyMeterX, this.energyMeterY, this.energyMeterWidth, this.energyMeterHeight, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.menu).getEnergy()), EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.menu).getCapacity())}));
            if (((IEnergyStorageMenu)this.menu).getEnergyIndicatorBarValue() > 0 && this.energyIndicatorBarTooltipComponentID != null) {
                components.add(Component.translatable((String)this.energyIndicatorBarTooltipComponentID, (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.menu).getEnergyIndicatorBarValue())}).withStyle(ChatFormatting.YELLOW));
            }
            if (((IEnergyStorageMenu)this.menu).getEnergyPerTickBarValue() > 0 && this.energyPerTickBarTooltipComponentID != null) {
                components.add(Component.translatable((String)this.energyPerTickBarTooltipComponentID, (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.menu).getEnergyPerTickBarValue()) + "/t"}).withStyle(ChatFormatting.YELLOW));
            }
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

