/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetWeatherFromWeatherControllerC2SPacket;
import me.jddev0.ep.screen.WeatherControllerMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageContainerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WeatherControllerScreen
extends UpgradableEnergyStorageContainerScreen<WeatherControllerMenu> {
    public WeatherControllerScreen(WeatherControllerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, EPAPI.id("textures/gui/container/weather_controller.png"), EPAPI.id("textures/gui/container/upgrade_view/1_duration.png"));
    }

    @Override
    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClickedNormalView(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0) {
            if (this.isHovering(52, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetWeatherFromWeatherControllerC2SPacket(((WeatherControllerBlockEntity)((WeatherControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 0));
                return true;
            }
            if (this.isHovering(88, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetWeatherFromWeatherControllerC2SPacket(((WeatherControllerBlockEntity)((WeatherControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 1));
                return true;
            }
            if (this.isHovering(124, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetWeatherFromWeatherControllerC2SPacket(((WeatherControllerBlockEntity)((WeatherControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 2));
                return true;
            }
        }
        return false;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderButtons(guiGraphics, x, y, mouseX, mouseY);
        this.renderInfoText(guiGraphics, x, y);
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        int selectedWeatherType = ((WeatherControllerMenu)this.menu).getSelectedWeatherType();
        if (this.isHovering(52, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 52, y + 34, 56, 193, 18, 18);
        } else if (selectedWeatherType == 0) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 52, y + 34, 74, 193, 18, 18);
        }
        if (this.isHovering(88, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 88, y + 34, 56, 211, 18, 18);
        } else if (selectedWeatherType == 1) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 88, y + 34, 74, 211, 18, 18);
        }
        if (this.isHovering(124, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 124, y + 34, 56, 229, 18, 18);
        } else if (selectedWeatherType == 2) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 124, y + 34, 74, 229, 18, 18);
        }
    }

    private void renderInfoText(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent component = ((WeatherControllerMenu)this.menu).hasEnoughEnergy() ? Component.translatable((String)"tooltip.energizedpower.ready.txt").withStyle(ChatFormatting.DARK_GREEN) : Component.translatable((String)"tooltip.energizedpower.not_enough_energy.txt").withStyle(ChatFormatting.RED);
        int componentWidth = this.font.width((FormattedText)component);
        guiGraphics.drawString(this.font, (Component)component, (int)((float)(x + 34) + (float)(126 - componentWidth) * 0.5f), y + 58, 0, false);
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.isHovering(52, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.weather_controller.btn.clear"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(88, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.weather_controller.btn.rain"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(124, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.weather_controller.btn.thunder"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

