/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.data.SimpleBooleanValueContainerData;
import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.inventory.data.SimpleShortValueContainerData;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WeatherControllerMenu
extends UpgradableEnergyStorageMenu<WeatherControllerBlockEntity> {
    private final SimpleShortValueContainerData selectedWeatherTypeData = new SimpleShortValueContainerData();
    private final SimpleEnergyValueContainerData energyConsumptionPerTickData = new SimpleEnergyValueContainerData();
    private final SimpleBooleanValueContainerData hasEnoughEnergyData = new SimpleBooleanValueContainerData();

    public WeatherControllerMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), new UpgradeModuleInventory(UpgradeModuleModifier.DURATION), null);
    }

    public WeatherControllerMenu(int id, Inventory inv, BlockEntity blockEntity, UpgradeModuleInventory upgradeModuleInventory, ContainerData data) {
        super(EPMenuTypes.WEATHER_CONTROLLER_MENU.get(), id, inv, blockEntity, (Block)EPBlocks.WEATHER_CONTROLLER.get(), upgradeModuleInventory, 1);
        this.addSlot(new UpgradeModuleSlot((Container)upgradeModuleInventory, 0, 80, 35, this::isInUpgradeModuleView));
        if (data == null) {
            this.addDataSlots(this.selectedWeatherTypeData);
            this.addDataSlots(this.energyConsumptionPerTickData);
            this.addDataSlots(this.hasEnoughEnergyData);
        } else {
            this.addDataSlots(data);
        }
    }

    @Override
    public int getEnergyPerTickBarValue() {
        return this.energyConsumptionPerTickData.getValue();
    }

    public int getSelectedWeatherType() {
        return this.selectedWeatherTypeData.getValue();
    }

    public boolean hasEnoughEnergy() {
        return this.hasEnoughEnergyData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 37) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

