/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.PressMoldMakerBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import me.jddev0.ep.screen.EPMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PressMoldMakerMenu
extends AbstractContainerMenu {
    private final PressMoldMakerBlockEntity blockEntity;
    private final Level level;

    public PressMoldMakerMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()));
    }

    public PressMoldMakerMenu(int id, Inventory inv, BlockEntity blockEntity) {
        super(EPMenuTypes.PRESS_MOLD_MAKER_MENU.get(), id);
        this.blockEntity = (PressMoldMakerBlockEntity)blockEntity;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> {
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 0, 8, 17));
            this.addSlot((Slot)new SlotItemHandler(itemHandler, 1, 8, 53));
        });
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 38) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean stillValid(Player player) {
        return PressMoldMakerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)EPBlocks.PRESS_MOLD_MAKER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> getRecipeList() {
        return this.blockEntity.getRecipeList();
    }
}

