/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.screen.ItemConveyorBeltSorterMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemConveyorBeltSorterScreen
extends EnergizedPowerBaseContainerScreen<ItemConveyorBeltSorterMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/item_conveyor_belt_sorter.png");

    public ItemConveyorBeltSorterScreen(ItemConveyorBeltSorterMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            for (int i = 0; i < 3; ++i) {
                if (this.isHovering(136, 19 + i * 18, 13, 13, mouseX, mouseY)) {
                    ModMessages.sendToServer(new SetCheckboxC2SPacket(((ItemConveyorBeltSorterMenu)this.menu).getBlockEntity().getBlockPos(), i, !((ItemConveyorBeltSorterMenu)this.menu).isWhitelist(i)));
                    clicked = true;
                    continue;
                }
                if (!this.isHovering(153, 19 + i * 18, 13, 13, mouseX, mouseY)) continue;
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((ItemConveyorBeltSorterMenu)this.menu).getBlockEntity().getBlockPos(), i + 3, !((ItemConveyorBeltSorterMenu)this.menu).isIgnoreNBT(i)));
                clicked = true;
            }
            if (clicked) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderOutputBeltConnectionState(guiGraphics, x, y, mouseX, mouseY);
        this.renderCheckboxes(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderOutputBeltConnectionState(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < 3; ++i) {
            if (!((ItemConveyorBeltSorterMenu)this.menu).isOutputBeltConnected(i)) continue;
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 10, y + 18 + i * 18, 22, 169 + i * 14, 30, 14);
        }
    }

    private void renderCheckboxes(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < 3; ++i) {
            if (((ItemConveyorBeltSorterMenu)this.menu).isWhitelist(i)) {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 136, y + 19 + i * 18, 13, 150, 13, 13);
            }
            if (!((ItemConveyorBeltSorterMenu)this.menu).isIgnoreNBT(i)) continue;
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 153, y + 19 + i * 18, 0, 150, 13, 13);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        for (int i = 0; i < 3; ++i) {
            ArrayList<MutableComponent> components;
            if (this.isHovering(10, 18 + i * 18, 30, 14, mouseX, mouseY)) {
                components = new ArrayList<MutableComponent>(2);
                components.add(Component.translatable((String)("tooltip.energizedpower.item_conveyor_belt_sorter.label.output_connection." + (((ItemConveyorBeltSorterMenu)this.menu).isOutputBeltConnected(i) ? "connection" : "no_connection")), (Object[])new Object[]{i + 1}));
                guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
                continue;
            }
            if (this.isHovering(136, 19 + i * 18, 13, 13, mouseX, mouseY)) {
                components = new ArrayList(2);
                components.add(Component.translatable((String)("tooltip.energizedpower.item_conveyor_belt_sorter.cbx." + (((ItemConveyorBeltSorterMenu)this.menu).isWhitelist(i) ? "whitelist" : "blacklist"))));
                guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
                continue;
            }
            if (!this.isHovering(153, 19 + i * 18, 13, 13, mouseX, mouseY)) continue;
            components = new ArrayList(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.item_conveyor_belt_sorter.cbx.ignore_nbt"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

