/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.networking.packet.SetFluidTankFilterC2SPacket;
import me.jddev0.ep.screen.FluidTankMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankScreen
extends EnergizedPowerBaseContainerScreen<FluidTankMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/fluid_tank.png");

    public FluidTankScreen(FluidTankMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.isHovering(158, 16, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((FluidTankMenu)this.menu).getBlockEntity().getBlockPos(), 0, !((FluidTankMenu)this.menu).isIgnoreNBT()));
                clicked = true;
            }
            if (this.isHovering(151, 34, 18, 18, mouseX, mouseY)) {
                FluidStack fluidFilter = FluidStack.EMPTY;
                ItemStack carriedItemStack = ((FluidTankMenu)this.menu).getCarried();
                IFluidHandlerItem fluidStorage = (IFluidHandlerItem)carriedItemStack.getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidStorage != null && fluidStorage.getTanks() > 0) {
                    fluidFilter = fluidStorage.getFluidInTank(0);
                }
                ModMessages.sendToServer(new SetFluidTankFilterC2SPacket(((FluidTankMenu)this.menu).getBlockEntity().getBlockPos(), fluidFilter));
                clicked = true;
            }
            if (clicked) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                this.renderFluidMeterContent(guiGraphics, ((FluidTankMenu)this.menu).getFluid(0), ((FluidTankMenu)this.menu).getTankCapacity(0), x + 80, y + 17, 16, 52);
            } else {
                this.renderFluidMeterContent(guiGraphics, ((FluidTankMenu)this.menu).getFluid(1), -1, x + 152, y + 35, 16, 16);
            }
            this.renderFluidMeterOverlay(guiGraphics, x, y, i);
        }
        this.renderCheckboxes(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y, int tank) {
        if (tank == 0) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 80, y + 17, 16, 0, 16, 52);
        } else if (tank == 1) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 152, y + 35, 0, 167, 16, 16);
        }
    }

    private void renderCheckboxes(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (((FluidTankMenu)this.menu).isIgnoreNBT()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 158, y + 16, 0, 139, 11, 11);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isHovering(80, 17, 16, 52, mouseX, mouseY)) {
            components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidTankMenu)this.menu).getFluid(0).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidTankMenu)this.menu).getFluid(0).getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidTankMenu)this.menu).getTankCapacity(0))});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((FluidTankMenu)this.menu).getFluid(0).getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(158, 16, 11, 11, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.fluid_tanks.cbx.ignore_nbt"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(151, 34, 18, 18, mouseX, mouseY)) {
            components = new ArrayList(2);
            FluidStack fluidFilter = ((FluidTankMenu)this.menu).getFluid(1);
            if (fluidFilter.isEmpty()) {
                components.add(Component.translatable((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.no_filter_set"));
            } else {
                components.add(Component.translatable((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.filter_set", (Object[])new Object[]{Component.translatable((String)fluidFilter.getDescriptionId())}));
            }
            components.add(Component.empty());
            components.add(Component.translatable((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.txt.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add(Component.translatable((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.txt.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

