/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.screen.FluidFillerMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FluidFillerScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<FluidFillerMenu> {
    public FluidFillerScreen(FluidFillerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, EPAPI.id("textures/gui/container/fluid_filler.png"), EPAPI.id("textures/gui/container/upgrade_view/1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderFluidMeterContent(guiGraphics, ((FluidFillerMenu)this.menu).getFluid(), ((FluidFillerMenu)this.menu).getTankCapacity(), x + 152, y + 17, 16, 52);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 152, y + 17, 16, 0, 16, 52);
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.isHovering(152, 17, 16, 52, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidFillerMenu)this.menu).getFluid().isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidFillerMenu)this.menu).getFluid().getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidFillerMenu)this.menu).getTankCapacity())});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((FluidFillerMenu)this.menu).getFluid().getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

