/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.screen.FiltrationPlantMenu;
import me.jddev0.ep.screen.base.SelectableRecipeMachineContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FiltrationPlantScreen
extends SelectableRecipeMachineContainerScreen<FiltrationPlantRecipe, FiltrationPlantMenu> {
    public FiltrationPlantScreen(FiltrationPlantMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/filtration_plant.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
        this.recipeSelectorPosX = 98;
    }

    @Override
    protected ItemStack getRecipeIcon(RecipeHolder<FiltrationPlantRecipe> currentRecipe) {
        ResourceLocation icon = ((FiltrationPlantRecipe)currentRecipe.value()).getIcon();
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(icon));
    }

    @Override
    protected void renderCurrentRecipeTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, RecipeHolder<FiltrationPlantRecipe> currentRecipe) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
        ItemStack[] maxOutputs = ((FiltrationPlantRecipe)currentRecipe.value()).getMaxOutputCounts();
        for (int i = 0; i < maxOutputs.length; ++i) {
            ItemStack output = maxOutputs[i];
            if (output.isEmpty()) continue;
            components.add(Component.empty().append(output.getHoverName()).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)"recipes.energizedpower.transfer.output_percentages")));
            double[] percentages = (i == 0 ? ((FiltrationPlantRecipe)currentRecipe.value()).getOutput() : ((FiltrationPlantRecipe)currentRecipe.value()).getSecondaryOutput()).percentages();
            for (int j = 0; j < percentages.length; ++j) {
                components.add(Component.literal((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", j + 1, 100.0 * percentages[j])));
            }
            components.add(Component.empty());
        }
        if (!components.isEmpty()) {
            components.removeLast();
        }
        guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((FiltrationPlantMenu)this.menu).getFluid(i), ((FiltrationPlantMenu)this.menu).getTankCapacity(i), x + (i == 0 ? 44 : 152), y + 17, 16, 52);
            this.renderFluidMeterOverlay(i, guiGraphics, x, y);
        }
        this.renderProgressArrows(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(int tank, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 16, 0, 16, 52);
    }

    private void renderProgressArrows(GuiGraphics guiGraphics, int x, int y) {
        if (((FiltrationPlantMenu)this.menu).isCraftingActive()) {
            for (int i = 0; i < 2; ++i) {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 67, y + 34 + 27 * i, 0, 108, ((FiltrationPlantMenu)this.menu).getScaledProgressArrowSize(), 9);
            }
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        int i;
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (i = 0; i < 2; ++i) {
            if (!this.isHovering(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FiltrationPlantMenu)this.menu).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FiltrationPlantMenu)this.menu).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FiltrationPlantMenu)this.menu).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((FiltrationPlantMenu)this.menu).getFluid(i).getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        for (i = 0; i < 2; ++i) {
            if (!this.isHovering(62 + 72 * i, 44, 16, 16, mouseX, mouseY) || !((FiltrationPlantMenu)this.menu).getSlot(36 + i).getItem().isEmpty()) continue;
            components = new ArrayList(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.filtration_plant.charcoal_filter_missing").withStyle(ChatFormatting.RED));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

