/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCreativeFluidTankFluidStackC2SPacket;
import me.jddev0.ep.screen.CreativeFluidTankMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

@OnlyIn(value=Dist.CLIENT)
public class CreativeFluidTankScreen
extends EnergizedPowerBaseContainerScreen<CreativeFluidTankMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/creative_fluid_tank.png");

    public CreativeFluidTankScreen(CreativeFluidTankMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.isHovering(48, 17, 80, 52, mouseX, mouseY)) {
                FluidStack fluidStack = FluidStack.EMPTY;
                ItemStack carriedItemStack = ((CreativeFluidTankMenu)this.menu).getCarried();
                IFluidHandlerItem fluidStorage = (IFluidHandlerItem)carriedItemStack.getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidStorage != null && fluidStorage.getTanks() > 0) {
                    fluidStack = fluidStorage.getFluidInTank(0);
                }
                ModMessages.sendToServer(new SetCreativeFluidTankFluidStackC2SPacket(((CreativeFluidTankMenu)this.menu).getBlockEntity().getBlockPos(), fluidStack));
                clicked = true;
            }
            if (clicked) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderFluidMeterContent(guiGraphics, ((CreativeFluidTankMenu)this.menu).getFluid(0), ((CreativeFluidTankMenu)this.menu).getTankCapacity(0), x + 48, y + 17, 80, 52);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 48, y + 17, 36, 0, 80, 52);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isHovering(48, 17, 80, 52, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((CreativeFluidTankMenu)this.menu).getFluid(0).isEmpty();
            MutableComponent tooltipComponent = fluidEmpty ? Component.literal((String)"0 / ").append((Component)Component.translatable((String)"tooltip.energizedpower.infinite.txt").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC})) : Component.translatable((String)((CreativeFluidTankMenu)this.menu).getFluid(0).getDescriptionId()).append(" ").append((Component)Component.translatable((String)"tooltip.energizedpower.infinite.txt").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC})).append(" / ").append((Component)Component.translatable((String)"tooltip.energizedpower.infinite.txt").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}));
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

