/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.CoalEngineBlockEntity;
import me.jddev0.ep.inventory.ItemCapabilityMenuHelper;
import me.jddev0.ep.inventory.UpgradeModuleSlot;
import me.jddev0.ep.inventory.data.SimpleBooleanValueContainerData;
import me.jddev0.ep.inventory.data.SimpleComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.inventory.data.SimpleProgressValueContainerData;
import me.jddev0.ep.inventory.data.SimpleRedstoneModeValueContainerData;
import me.jddev0.ep.inventory.upgrade.UpgradeModuleInventory;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.IEnergyStorageProducerIndicatorBarMenu;
import me.jddev0.ep.screen.base.UpgradableEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CoalEngineMenu
extends UpgradableEnergyStorageMenu<CoalEngineBlockEntity>
implements IEnergyStorageProducerIndicatorBarMenu,
IConfigurableMenu {
    private final SimpleProgressValueContainerData progressData = new SimpleProgressValueContainerData();
    private final SimpleProgressValueContainerData maxProgressData = new SimpleProgressValueContainerData();
    private final SimpleEnergyValueContainerData energyProductionPerTickData = new SimpleEnergyValueContainerData();
    private final SimpleEnergyValueContainerData energyProductionLeftData = new SimpleEnergyValueContainerData();
    private final SimpleBooleanValueContainerData hasEnoughCapacityForProductionData = new SimpleBooleanValueContainerData();
    private final SimpleRedstoneModeValueContainerData redstoneModeData = new SimpleRedstoneModeValueContainerData();
    private final SimpleComparatorModeValueContainerData comparatorModeData = new SimpleComparatorModeValueContainerData();

    public CoalEngineMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.player.level().getBlockEntity(buffer.readBlockPos()), new UpgradeModuleInventory(UpgradeModuleModifier.ENERGY_CAPACITY), null);
    }

    public CoalEngineMenu(int id, Inventory inv, BlockEntity blockEntity, UpgradeModuleInventory upgradeModuleInventory, ContainerData data) {
        super(EPMenuTypes.COAL_ENGINE_MENU.get(), id, inv, blockEntity, (Block)EPBlocks.COAL_ENGINE.get(), upgradeModuleInventory, 1);
        ItemCapabilityMenuHelper.getCapabilityItemHandler(this.level, this.blockEntity).ifPresent(itemHandler -> this.addSlot((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 80, 44){

            public boolean isActive() {
                return super.isActive() && !CoalEngineMenu.this.isInUpgradeModuleView();
            }
        }));
        this.addSlot(new UpgradeModuleSlot((Container)upgradeModuleInventory, 0, 80, 35, this::isInUpgradeModuleView));
        if (data == null) {
            this.addDataSlots(this.progressData);
            this.addDataSlots(this.maxProgressData);
            this.addDataSlots(this.energyProductionPerTickData);
            this.addDataSlots(this.energyProductionLeftData);
            this.addDataSlots(this.hasEnoughCapacityForProductionData);
            this.addDataSlots(this.redstoneModeData);
            this.addDataSlots(this.comparatorModeData);
        } else {
            this.addDataSlots(data);
        }
    }

    @Override
    public int getEnergyIndicatorBarValue() {
        return this.energyProductionLeftData.getValue();
    }

    @Override
    public int getEnergyPerTickBarValue() {
        return this.energyProductionPerTickData.getValue();
    }

    public boolean isProducingActive() {
        return this.progressData.getValue() > 0;
    }

    public boolean isProducing() {
        return this.progressData.getValue() > 0 && this.hasEnoughCapacityForProductionData.getValue();
    }

    public int getScaledProgressFlameSize() {
        int progress = this.progressData.getValue();
        int maxProgress = this.maxProgressData.getValue();
        int progressFlameSize = 14;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressFlameSize / maxProgress;
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneModeData.getValue();
    }

    @Override
    public ComparatorMode getComparatorMode() {
        return this.comparatorModeData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceItem = sourceSlot.getItem();
        ItemStack sourceItemCopy = sourceItem.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceItem, 37, 38, false) && !this.moveItemStackTo(sourceItem, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 38) {
            if (!this.moveItemStackTo(sourceItem, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceItem);
        return sourceItemCopy;
    }
}

