/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.screen.AdvancedPulverizerMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedPulverizerScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<AdvancedPulverizerMenu> {
    public AdvancedPulverizerScreen(AdvancedPulverizerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/advanced_pulverizer.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((AdvancedPulverizerMenu)this.menu).getFluid(i), ((AdvancedPulverizerMenu)this.menu).getTankCapacity(i), x + (i == 0 ? 44 : 152), y + 17, 16, 52);
            this.renderFluidMeterOverlay(i, guiGraphics, x, y);
        }
        this.renderProgressArrow(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(int tank, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 16, 0, 16, 52);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AdvancedPulverizerMenu)this.menu).isCraftingActive()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 90, y + 34, 0, 58, ((AdvancedPulverizerMenu)this.menu).getScaledProgressArrowSize(), 17);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (int i = 0; i < 2; ++i) {
            if (!this.isHovering(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((AdvancedPulverizerMenu)this.menu).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((AdvancedPulverizerMenu)this.menu).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((AdvancedPulverizerMenu)this.menu).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((AdvancedPulverizerMenu)this.menu).getFluid(i).getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

