/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.recipe.EPRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TeleporterMatrixSettingsCopyRecipe
extends CustomRecipe {
    public TeleporterMatrixSettingsCopyRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput container, Level level) {
        ItemStack linkedTransportMatrix = ItemStack.EMPTY;
        int count = 0;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack itemStack = container.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (!itemStack.is((Item)EPItems.TELEPORTER_MATRIX.get())) {
                return false;
            }
            if (TeleporterMatrixItem.isLinked(itemStack)) {
                if (!linkedTransportMatrix.isEmpty()) {
                    return false;
                }
                linkedTransportMatrix = itemStack;
                continue;
            }
            if (++count <= 64) continue;
            return false;
        }
        return !linkedTransportMatrix.isEmpty() && count > 0;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registries) {
        ItemStack linkedTransportMatrix = ItemStack.EMPTY;
        int count = 0;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack itemStack = container.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (!itemStack.is((Item)EPItems.TELEPORTER_MATRIX.get())) {
                return ItemStack.EMPTY;
            }
            if (TeleporterMatrixItem.isLinked(itemStack)) {
                if (!linkedTransportMatrix.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                linkedTransportMatrix = itemStack;
                continue;
            }
            if (++count <= 64) continue;
            return ItemStack.EMPTY;
        }
        return !linkedTransportMatrix.isEmpty() && count > 0 ? linkedTransportMatrix.copyWithCount(count) : ItemStack.EMPTY;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)EPItems.TELEPORTER_MATRIX.get(), 2);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput container) {
        NonNullList remainders = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainders.size(); ++i) {
            ItemStack itemstack = container.getItem(i);
            if (itemstack.isEmpty()) continue;
            if (itemstack.hasCraftingRemainingItem()) {
                remainders.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (!itemstack.is((Item)EPItems.TELEPORTER_MATRIX.get()) || !TeleporterMatrixItem.isLinked(itemstack)) continue;
            remainders.set(i, (Object)itemstack.copyWithCount(1));
        }
        return remainders;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPItems.TELEPORTER_MATRIX.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return EPRecipes.TELEPORTER_MATRIX_SETTINGS_COPY_SERIALIZER.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }
}

