/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlantGrowthChamberRecipe
implements Recipe<RecipeInput> {
    private final OutputItemStackWithPercentages[] outputs;
    private final Ingredient input;
    private final int ticks;

    public PlantGrowthChamberRecipe(OutputItemStackWithPercentages[] outputs, Ingredient input, int ticks) {
        this.outputs = outputs;
        this.input = input;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages[] getOutputs() {
        return this.outputs;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            OutputItemStackWithPercentages output = this.outputs[i];
            generatedOutputs[i] = output.output().copyWithCount(output.percentages().length);
        }
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = this.outputs[i];
            for (double percentage : output.percentages()) {
                if (!(randomSource.nextDouble() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output().copyWithCount(count);
        }
        return generatedOutputs;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(container.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.PLANT_GROWTH_CHAMBER_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<PlantGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("plant_growth_chamber");
        private final MapCodec<PlantGrowthChamberRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)new ArrayCodec<OutputItemStackWithPercentages>(OutputItemStackWithPercentages.CODEC_NONEMPTY, OutputItemStackWithPercentages[]::new).fieldOf("outputs").forGetter(recipe -> recipe.outputs), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ExtraCodecs.POSITIVE_INT.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, PlantGrowthChamberRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, PlantGrowthChamberRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<PlantGrowthChamberRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PlantGrowthChamberRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static PlantGrowthChamberRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int ticks = buffer.readInt();
            int outputCount = buffer.readInt();
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                outputs[i] = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            }
            return new PlantGrowthChamberRecipe(outputs, input, ticks);
        }

        private static void write(RegistryFriendlyByteBuf buffer, PlantGrowthChamberRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeInt(recipe.ticks);
            buffer.writeInt(recipe.outputs.length);
            for (OutputItemStackWithPercentages output : recipe.outputs) {
                OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)output);
            }
        }
    }

    public static final class Type
    implements RecipeType<PlantGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plant_growth_chamber";

        private Type() {
        }
    }
}

