/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MetalPressRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final ItemStack pressMold;
    private final Ingredient input;
    private final int inputCount;

    public MetalPressRecipe(ItemStack output, ItemStack pressMold, Ingredient input, int inputCount) {
        this.output = output;
        this.pressMold = pressMold;
        this.input = input;
        this.inputCount = inputCount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getPressMold() {
        return this.pressMold;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(container.getItem(0)) && container.getItem(0).getCount() >= this.inputCount && ItemStack.isSameItem((ItemStack)container.getItem(1), (ItemStack)this.pressMold);
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.METAL_PRESS_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<MetalPressRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("metal_press");
        private final MapCodec<MetalPressRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)CodecFix.ITEM_STACK_CODEC.fieldOf("pressMold").forGetter(recipe -> recipe.pressMold), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("inputCount", (Object)1).forGetter(recipe -> recipe.inputCount)).apply((Applicative)instance, MetalPressRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, MetalPressRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<MetalPressRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MetalPressRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static MetalPressRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int inputCount = buffer.readInt();
            ItemStack pressMold = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new MetalPressRecipe(output, pressMold, input, inputCount);
        }

        private static void write(RegistryFriendlyByteBuf buffer, MetalPressRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeInt(recipe.inputCount);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.pressMold);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static final class Type
    implements RecipeType<MetalPressRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "metal_press";

        private Type() {
        }
    }
}

