/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public class HeatGeneratorRecipe
implements Recipe<RecipeInput> {
    private final Fluid[] input;
    private final int energyProduction;

    public HeatGeneratorRecipe(Fluid[] input, int energyProduction) {
        this.input = input;
        this.energyProduction = energyProduction;
    }

    public Fluid[] getInput() {
        return this.input;
    }

    public int getEnergyProduction() {
        return this.energyProduction;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.HEAT_GENERATOR_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<HeatGeneratorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("heat_generator");
        private final MapCodec<HeatGeneratorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either(new ArrayCodec(BuiltInRegistries.FLUID.byNameCodec(), Fluid[]::new), (Codec)BuiltInRegistries.FLUID.byNameCodec()).fieldOf("input").forGetter(recipe -> recipe.input.length == 1 ? Either.right((Object)recipe.input[0]) : Either.left((Object)recipe.input)), (App)Codec.INT.fieldOf("energy").forGetter(recipe -> recipe.energyProduction)).apply((Applicative)instance, (input, energy) -> (HeatGeneratorRecipe)input.map(f -> new HeatGeneratorRecipe((Fluid[])f, (int)energy), f -> new HeatGeneratorRecipe(new Fluid[]{f}, (int)energy))));
        private final StreamCodec<RegistryFriendlyByteBuf, HeatGeneratorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<HeatGeneratorRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HeatGeneratorRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static HeatGeneratorRecipe read(RegistryFriendlyByteBuf buffer) {
            int fluidCount = buffer.readInt();
            Fluid[] input = new Fluid[fluidCount];
            for (int i = 0; i < fluidCount; ++i) {
                input[i] = (Fluid)BuiltInRegistries.FLUID.get(buffer.readResourceLocation());
            }
            int energyProduction = buffer.readInt();
            return new HeatGeneratorRecipe(input, energyProduction);
        }

        private static void write(RegistryFriendlyByteBuf buffer, HeatGeneratorRecipe recipe) {
            buffer.writeInt(recipe.getInput().length);
            for (Fluid fluid : recipe.input) {
                ResourceLocation fluidId = BuiltInRegistries.FLUID.getKey((Object)fluid);
                if (fluidId == null || fluidId.equals((Object)ResourceLocation.withDefaultNamespace((String)"empty"))) {
                    throw new IllegalArgumentException("Unregistered fluid '" + String.valueOf(fluid) + "'");
                }
                buffer.writeResourceLocation(fluidId);
            }
            buffer.writeInt(recipe.energyProduction);
        }
    }

    public static final class Type
    implements RecipeType<HeatGeneratorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "heat_generator";

        private Type() {
        }
    }
}

