/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SetWeatherFromWeatherControllerC2SPacket(BlockPos pos, int weatherType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetWeatherFromWeatherControllerC2SPacket> ID = new CustomPacketPayload.Type(EPAPI.id("set_weather_from_weather_controller"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetWeatherFromWeatherControllerC2SPacket> STREAM_CODEC = StreamCodec.ofMember(SetWeatherFromWeatherControllerC2SPacket::write, SetWeatherFromWeatherControllerC2SPacket::new);

    public SetWeatherFromWeatherControllerC2SPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readInt());
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.weatherType);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(SetWeatherFromWeatherControllerC2SPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt1$temp;
            ServerLevel level;
            block15: {
                block14: {
                    Level patt0$temp = context.player().level();
                    if (!(patt0$temp instanceof ServerLevel)) break block14;
                    level = (ServerLevel)patt0$temp;
                    patt1$temp = context.player();
                    if (patt1$temp instanceof ServerPlayer) break block15;
                }
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1$temp;
            if (!level.hasChunk(SectionPos.blockToSectionCoord((int)data.pos.getX()), SectionPos.blockToSectionCoord((int)data.pos.getZ()))) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(data.pos);
            if (!(blockEntity instanceof WeatherControllerBlockEntity)) {
                return;
            }
            WeatherControllerBlockEntity weatherControllerBlockEntity = (WeatherControllerBlockEntity)blockEntity;
            if (!weatherControllerBlockEntity.hasEnoughEnergy()) {
                return;
            }
            if (weatherControllerBlockEntity.hasInfiniteWeatherChangedDuration()) {
                if (weatherControllerBlockEntity.getSelectedWeatherType() == data.weatherType) {
                    weatherControllerBlockEntity.setSelectedWeatherType(-1);
                    return;
                }
                weatherControllerBlockEntity.setSelectedWeatherType(data.weatherType);
            } else {
                weatherControllerBlockEntity.clearEnergy();
            }
            int duration = weatherControllerBlockEntity.getWeatherChangedDuration();
            switch (data.weatherType) {
                case 0: {
                    level.setWeatherParameters(duration, 0, false, false);
                    break;
                }
                case 1: {
                    level.setWeatherParameters(0, duration, true, false);
                    break;
                }
                case 2: {
                    level.setWeatherParameters(0, duration, true, true);
                }
            }
        });
    }
}

