/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.AutoCrafterBlockEntity;
import me.jddev0.ep.screen.AutoCrafterMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public final class SetAutoCrafterPatternInputSlotsC2SPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SetAutoCrafterPatternInputSlotsC2SPacket> ID = new CustomPacketPayload.Type(EPAPI.id("set_auto_crafter_pattern_input_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetAutoCrafterPatternInputSlotsC2SPacket> STREAM_CODEC = StreamCodec.ofMember(SetAutoCrafterPatternInputSlotsC2SPacket::write, SetAutoCrafterPatternInputSlotsC2SPacket::new);
    private final BlockPos pos;
    private final List<ItemStack> itemStacks;
    private final ResourceLocation recipeId;

    public SetAutoCrafterPatternInputSlotsC2SPacket(BlockPos pos, List<ItemStack> itemStacks, ResourceLocation recipeId) {
        this.pos = pos;
        this.itemStacks = new ArrayList<ItemStack>(itemStacks);
        while (this.itemStacks.size() < 9) {
            this.itemStacks.add(ItemStack.EMPTY);
        }
        this.recipeId = recipeId;
    }

    public SetAutoCrafterPatternInputSlotsC2SPacket(RegistryFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.itemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            this.itemStacks.add((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
        }
        this.recipeId = buffer.readResourceLocation();
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        for (ItemStack itemStack : this.itemStacks) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)itemStack);
        }
        buffer.writeResourceLocation(this.recipeId);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(SetAutoCrafterPatternInputSlotsC2SPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt1$temp;
            ServerLevel level;
            block8: {
                block7: {
                    Level patt0$temp = context.player().level();
                    if (!(patt0$temp instanceof ServerLevel)) break block7;
                    level = (ServerLevel)patt0$temp;
                    patt1$temp = context.player();
                    if (patt1$temp instanceof ServerPlayer) break block8;
                }
                return;
            }
            ServerPlayer player = (ServerPlayer)patt1$temp;
            if (!level.hasChunk(SectionPos.blockToSectionCoord((int)data.pos.getX()), SectionPos.blockToSectionCoord((int)data.pos.getZ()))) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(data.pos);
            if (!(blockEntity instanceof AutoCrafterBlockEntity)) {
                return;
            }
            AutoCrafterBlockEntity autoCrafterBlockEntity = (AutoCrafterBlockEntity)blockEntity;
            AbstractContainerMenu menu = player.containerMenu;
            if (!(menu instanceof AutoCrafterMenu)) {
                return;
            }
            AutoCrafterMenu autoCrafterMenu = (AutoCrafterMenu)menu;
            for (int i = 0; i < data.itemStacks.size(); ++i) {
                autoCrafterMenu.getPatternSlots().setItem(i, data.itemStacks.get(i));
            }
            autoCrafterBlockEntity.setRecipeIdForSetRecipe(data.recipeId);
            autoCrafterBlockEntity.resetProgressAndMarkAsChanged();
        });
    }
}

