/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.inventory.ItemStackPacketUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ItemStackSyncS2CPacket(int slot, ItemStack itemStack, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ItemStackSyncS2CPacket> ID = new CustomPacketPayload.Type(EPAPI.id("item_stack_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackSyncS2CPacket> STREAM_CODEC = StreamCodec.ofMember(ItemStackSyncS2CPacket::write, ItemStackSyncS2CPacket::new);

    public ItemStackSyncS2CPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.readInt(), (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer), buffer.readBlockPos());
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.slot);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.itemStack);
        buffer.writeBlockPos(this.pos);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(ItemStackSyncS2CPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity blockEntity = context.player().level().getBlockEntity(data.pos);
            if (blockEntity instanceof ItemStackPacketUpdate) {
                ItemStackPacketUpdate itemStackStorage = (ItemStackPacketUpdate)blockEntity;
                itemStackStorage.setItemStack(data.slot, data.itemStack);
            }
        });
    }
}

