/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.component.CurrentItemStackComponent;
import me.jddev0.ep.component.EPDataComponentTypes;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.item.ActivatableItem;
import me.jddev0.ep.item.WorkingItem;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class InventoryCoalEngineItem
extends EnergizedPowerEnergyItem
implements ActivatableItem,
WorkingItem {
    public static final int CAPACITY = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_CAPACITY.getValue();
    public static final int MAX_EXTRACT = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_TRANSFER_RATE.getValue();
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();

    public InventoryCoalEngineItem(Item.Properties props) {
        super(props, () -> new ExtractOnlyEnergyStorage(0, CAPACITY, MAX_EXTRACT));
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, components, tooltipFlag);
        boolean active = this.isActive(itemStack);
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_coal_engine.status").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("tooltip.energizedpower.inventory_coal_engine.status." + (active ? "activated" : "deactivated"))).withStyle(active ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (Screen.hasShiftDown()) {
            int energyProductionLeft = this.getEnergyProductionLeft(itemStack);
            ItemStack item = this.getCurrentBurningItem(itemStack);
            if (energyProductionLeft > 0 && item != null) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.currently_burning").withStyle(ChatFormatting.GRAY).append(item.getDisplayName()));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.energy_production_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energyProductionLeft)}).withStyle(ChatFormatting.GRAY));
            }
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    private int addConsumerEnergyItem(List<IEnergyStorage> consumerItems, List<Integer> consumerEnergyValues, ItemStack itemStack, ItemStack testItemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)testItemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null || !energyStorage.canReceive()) {
            return 0;
        }
        int received = energyStorage.receiveEnergy(Math.min(MAX_EXTRACT, InventoryCoalEngineItem.getEnergy(itemStack)), true);
        if (received <= 0) {
            return 0;
        }
        consumerItems.add(energyStorage);
        consumerEnergyValues.add(received);
        return received;
    }

    private void distributeEnergy(ItemStack itemStack, Level level, Inventory inventory, int slot, boolean selected) {
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (i == slot) continue;
            ItemStack testItemStack = inventory.getItem(i);
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack);
        }
        List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
        for (ItemStack testItemStack : curiosItemStacks) {
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(MAX_EXTRACT, Math.min(InventoryCoalEngineItem.getEnergy(itemStack), consumptionSum));
        InventoryCoalEngineItem.setEnergy(itemStack, InventoryCoalEngineItem.getEnergy(itemStack) - consumptionLeft);
        int divisor = consumerItems.size();
        block3: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block3;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemStack, level, entity, slot, selected);
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        if (!this.isActive(itemStack)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.getInventory();
        this.distributeEnergy(itemStack, level, inventory, slot, selected);
        int energyProductionLeft = this.getEnergyProductionLeft(itemStack);
        if (energyProductionLeft > 0) {
            int progress = this.getProgress(itemStack);
            int maxProgress = this.getMaxProgress(itemStack);
            ItemStack currentBurningItem = this.getCurrentBurningItem(itemStack);
            if (progress >= 0 && maxProgress > 0 && progress < maxProgress && currentBurningItem != null) {
                int energyProductionPerTick = energyProductionLeft / (maxProgress - progress);
                if (InventoryCoalEngineItem.getCapacity(itemStack) - InventoryCoalEngineItem.getEnergy(itemStack) < energyProductionPerTick) {
                    if (!this.isWorking(itemStack)) return;
                    itemStack.set(EPDataComponentTypes.WORKING, (Object)false);
                    return;
                }
                if (!this.isWorking(itemStack)) {
                    itemStack.set(EPDataComponentTypes.WORKING, (Object)true);
                }
                InventoryCoalEngineItem.setEnergy(itemStack, InventoryCoalEngineItem.getEnergy(itemStack) + energyProductionPerTick);
                itemStack.set(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT, (Object)(energyProductionLeft - energyProductionPerTick));
                if (++progress != maxProgress) {
                    itemStack.set(EPDataComponentTypes.PROGRESS, (Object)progress);
                    return;
                }
                this.resetProgress(itemStack);
            } else {
                this.resetProgress(itemStack);
            }
        }
        int i = 9;
        while (i < inventory.items.size()) {
            ItemStack testItemStack;
            int energyProduction;
            if (i != slot && (energyProduction = (testItemStack = inventory.getItem(i)).getBurnTime(null)) > 0) {
                energyProduction = (int)((float)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
                itemStack.set(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT, (Object)energyProduction);
                itemStack.set(EPDataComponentTypes.CURRENT_ITEM, (Object)new CurrentItemStackComponent(testItemStack));
                itemStack.set(EPDataComponentTypes.PROGRESS, (Object)0);
                if (energyProduction / 100 <= MAX_EXTRACT) {
                    itemStack.set(EPDataComponentTypes.MAX_PROGRESS, (Object)100);
                } else {
                    itemStack.set(EPDataComponentTypes.MAX_PROGRESS, (Object)((int)Math.ceil((double)energyProduction / (double)MAX_EXTRACT)));
                }
                ItemStack newItemStack = testItemStack.copy();
                newItemStack.shrink(1);
                inventory.setItem(i, newItemStack);
                if (!testItemStack.hasCraftingRemainingItem()) return;
                ItemStack craftingRemainingItem = testItemStack.getCraftingRemainingItem();
                if (!inventory.add(craftingRemainingItem)) return;
                player.drop(craftingRemainingItem, false);
                return;
            }
            ++i;
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        itemStack.set(EPDataComponentTypes.ACTIVE, (Object)(!this.isActive(itemStack) ? 1 : 0));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private void resetProgress(ItemStack itemStack) {
        itemStack.remove(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT);
        itemStack.remove(EPDataComponentTypes.PROGRESS);
        itemStack.remove(EPDataComponentTypes.MAX_PROGRESS);
        itemStack.remove(EPDataComponentTypes.CURRENT_ITEM);
        itemStack.remove(EPDataComponentTypes.WORKING);
    }

    private int getProgress(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(EPDataComponentTypes.PROGRESS, (Object)-1);
    }

    private int getMaxProgress(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(EPDataComponentTypes.MAX_PROGRESS, (Object)-1);
    }

    private ItemStack getCurrentBurningItem(ItemStack itemStack) {
        CurrentItemStackComponent currentItem = (CurrentItemStackComponent)itemStack.get(EPDataComponentTypes.CURRENT_ITEM);
        return currentItem == null ? null : currentItem.getCurrentItem();
    }

    private int getEnergyProductionLeft(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(EPDataComponentTypes.ENERGY_PRODUCTION_LEFT, (Object)-1);
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        return (Boolean)itemStack.getOrDefault(EPDataComponentTypes.ACTIVE, (Object)false);
    }

    @Override
    public boolean isWorking(ItemStack itemStack) {
        return (Boolean)itemStack.getOrDefault(EPDataComponentTypes.WORKING, (Object)false);
    }
}

