/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.screen.EnergizedPowerBookScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnergizedPowerBookItem
extends WrittenBookItem {
    public EnergizedPowerBookItem(Item.Properties props) {
        super(props);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{"JDDev0"}).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)"book.generation.0").withStyle(ChatFormatting.GRAY));
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.energized_power_book.txt.shift.1").withStyle(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (level.isClientSide) {
            this.showBookViewScreen(null);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        return Float.POSITIVE_INFINITY;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos blockPos, Player player) {
        if (!level.isClientSide) {
            return false;
        }
        this.showBookViewScreen(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()));
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showBookViewScreen(ResourceLocation openOnPageForBlock) {
        Minecraft.getInstance().setScreen((Screen)new EnergizedPowerBookScreen(openOnPageForBlock));
    }

    public boolean isFoil(ItemStack itemStack) {
        return false;
    }
}

