/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.entity.MinecartBatteryBox;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;

public class BatteryBoxMinecartItem
extends Item {
    private static final DefaultDispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private static final DefaultDispenseItemBehavior DEFAULT_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
            double additionalYOffset;
            RailShape railShape;
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = blockSource.level();
            double xOffset = blockSource.center().x() + (double)direction.getStepX() * 1.125;
            double yOffset = Math.floor(blockSource.center().y()) + (double)direction.getStepY();
            double zOffset = blockSource.center().z() + (double)direction.getStepZ() * 1.125;
            BlockPos blockPos = blockSource.pos().relative(direction);
            BlockState blockState = level.getBlockState(blockPos);
            RailShape railShape2 = railShape = blockState.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockState.getBlock()).getRailDirection(blockState, (BlockGetter)level, blockPos, null) : RailShape.NORTH_SOUTH;
            if (blockState.is(BlockTags.RAILS)) {
                additionalYOffset = railShape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!blockState.isAir() || !level.getBlockState(blockPos.below()).is(BlockTags.RAILS)) {
                    return DEFAULT_ITEM_BEHAVIOR.dispense(blockSource, itemStack);
                }
                BlockState blockStateBelow = level.getBlockState(blockPos.below());
                RailShape railShapeBelow = blockStateBelow.getBlock() instanceof BaseRailBlock ? (RailShape)blockStateBelow.getValue(((BaseRailBlock)blockStateBelow.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                additionalYOffset = direction != Direction.DOWN && railShapeBelow.isAscending() ? -0.4 : -0.9;
            }
            MinecartBatteryBox minecartBatteryBox = new MinecartBatteryBox((Level)level, xOffset, yOffset + additionalYOffset, zOffset);
            if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                minecartBatteryBox.setCustomName(itemStack.getHoverName());
            }
            level.addFreshEntity((Entity)minecartBatteryBox);
            itemStack.shrink(1);
            return itemStack;
        }
    };

    public BatteryBoxMinecartItem(Item.Properties props) {
        super(props);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.capacity.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(MinecartBatteryBox.CAPACITY)}).withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(MinecartBatteryBox.MAX_TRANSFER)}).withStyle(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockPos blockPos;
        Level level = useOnContext.getLevel();
        BlockState blockState = level.getBlockState(blockPos = useOnContext.getClickedPos());
        if (!blockState.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = useOnContext.getItemInHand();
        if (!level.isClientSide) {
            RailShape railShape = blockState.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockState.getBlock()).getRailDirection(blockState, (BlockGetter)level, blockPos, null) : RailShape.NORTH_SOUTH;
            double yOffset = railShape.isAscending() ? 0.5 : 0.0;
            MinecartBatteryBox minecartBatteryBox = new MinecartBatteryBox(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.0625 + yOffset, (double)blockPos.getZ() + 0.5);
            if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                minecartBatteryBox.setCustomName(itemStack.getHoverName());
            }
            level.addFreshEntity((Entity)minecartBatteryBox);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockPos, GameEvent.Context.of((Entity)useOnContext.getPlayer(), (BlockState)level.getBlockState(blockPos.below())));
        }
        itemStack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

