/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory;

import java.util.Optional;
import me.jddev0.ep.inventory.SingleItemStackHandler;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ViewOnlySlot
extends Slot {
    private static final Container EMPTY_INVENTORY = new SimpleContainer(0);
    private final SingleItemStackHandler itemHandler;
    protected final int index;

    public ViewOnlySlot(SingleItemStackHandler itemHandler, int index, int x, int y) {
        super(EMPTY_INVENTORY, index, x, y);
        this.itemHandler = itemHandler;
        this.index = index;
    }

    protected void onQuickCraft(ItemStack itemStack, int amount) {
    }

    public boolean mayPlace(ItemStack itemStack) {
        return false;
    }

    public ItemStack getItem() {
        return this.getItemHandler().getStack();
    }

    public void set(ItemStack stack) {
        this.itemHandler.setStackInSlot(this.index, stack);
        this.setChanged();
    }

    public boolean mayPickup(Player player) {
        return true;
    }

    public ItemStack safeInsert(ItemStack itemStack, int amount) {
        return itemStack;
    }

    public Optional<ItemStack> tryRemove(int count, int limit, Player player) {
        return Optional.empty();
    }

    public boolean isFake() {
        return true;
    }

    public SingleItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameInventory(Slot other) {
        if (!(other instanceof ViewOnlySlot)) return false;
        ViewOnlySlot that = (ViewOnlySlot)other;
        if (that.itemHandler != this.itemHandler) return false;
        return true;
    }
}

