/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SingleItemStackHandler
extends ItemStackHandler {
    protected final int slotCount;
    protected int count;
    protected ItemStack stack = ItemStack.EMPTY;

    public SingleItemStackHandler(int slotCount) {
        this.slotCount = slotCount;
    }

    public void setSize(int size) {
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        this.count = stack.getCount();
        this.stack = stack.copyWithCount(1);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getStack() {
        return this.stack.copy();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        if (this.count == 0) {
            return ItemStack.EMPTY;
        }
        int maxStackSize = this.stack.getMaxStackSize();
        if (this.count <= slot * maxStackSize) {
            return ItemStack.EMPTY;
        }
        int itemCount = Math.min(this.count - slot * maxStackSize, maxStackSize);
        return this.stack.copyWithCount(itemCount);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int limit = Math.min(stack.getMaxStackSize(), this.slotCount * stack.getMaxStackSize() - this.count);
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (this.stack.isEmpty()) {
                this.stack = stack.copyWithCount(1);
            }
            this.count += reachedLimit ? limit : stack.getCount();
            this.onContentsChanged(slot);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        if (this.stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.stack.copy();
        int existingCount = this.count;
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (this.count <= toExtract) {
            if (!simulate) {
                this.count = 0;
                this.stack = ItemStack.EMPTY;
                this.onContentsChanged(slot);
            }
            return existing.copyWithCount(existingCount);
        }
        if (!simulate) {
            this.count -= toExtract;
            this.onContentsChanged(slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public final int getSlotLimit(int slot) {
        return 99;
    }

    protected final int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.stack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("Count", this.count);
        if (!this.stack.isEmpty()) {
            nbt.put("Item", this.stack.save(lookupProvider, (Tag)new CompoundTag()));
            nbt.getCompound("Item").remove("count");
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        this.count = nbt.getInt("Count");
        if (this.count == 0) {
            this.stack = ItemStack.EMPTY;
        } else {
            CompoundTag itemNbt = nbt.getCompound("Item");
            itemNbt.putInt("count", 1);
            this.stack = ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)itemNbt).orElse(ItemStack.EMPTY).copyWithCount(1);
        }
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slotCount) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slotCount + ")");
        }
    }
}

